#
# $Id: abstorel_filter.rb,v 1.1 2004/01/17 12:02:27 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'webpub/publisher'

module WebPub

class AbsToRelFilter < HTFilter

	def initialize
	end

	def filter(desc, lines)
		dist = ''
		lines.each_line { |line|
			if /</ === line
				line.gsub!(%r!(\s.+?=\")(/.+?)(")!) {
					$1 + to_rel(desc.publish_to, desc.web_project.publish_dir + $2) + $3
				}
			end
			dist << line
		}
		
		dist
	end

	private

	def to_rel(base, target)
		sep = /#{File::SEPARATOR}+/o
		base = base.split(sep)
		base.pop
		target = target.split(sep)
		while base.first == target.first
			base.shift
			target.shift
		end
		File.join([".."]*base.size+target)
	end

end

end