# $Id: navigation_test.rb,v 1.1 2004/01/17 12:02:32 hn Exp $
# Copyright Narushima Hironori. All rights reserved.

project_dir = File.dirname(__FILE__).sub(/(com.narucy.webpub.core).+/, '\1')
Dir.chdir project_dir
$: << project_dir + '/scripts/lib'

require 'test/unit'
require 'sitemapper/navigation'

=begin

= NavigationTest

--- test_to_relative
		tests to_rel method. (That create relative path from two absolute path)
--- test_choose_next
		Choose next page object as a path form site map.
--- test_choose_prev
		Choose previous page object as a path form site map.
--- test_create_navi
		Test for create navigation object form includes url.
--- test_create_navi2
		Test for create navigation object.


=end
class NavigationTest < Test::Unit::TestCase

	include SiteMapper

	def test_to_relative
		current = '/dir_1/dir_2/dir_3/test.txt'
		child = '/dir_1/dir_2/dir_3/dir_4/dir_5/test.txt'
		assert_equal('dir_4/dir_5/test.txt', to_rel(current, child) )
		
		parent = '/dir_1/test.txt'
		assert_equal('../../test.txt', to_rel(current, parent) )
		
		in_parent1 = '/dir_1/dir_6/dir_7/test.txt'
		assert_equal('../../dir_6/dir_7/test.txt', to_rel(current, in_parent1) )
		
		in_parent2 = '/dir_8/test.txt'
		assert_equal('../../../dir_8/test.txt', to_rel(current, in_parent2) )
	end

	def test_choose_next
		fac = NavigatorFactory.new('test_resources/sitemap_test1/toc.xml')
		doc = fac.doc
		
		# to children
		elem = fac.search_element(doc, 'test1/a.html')
		e = fac.choose_next(elem)
		assert_equal('test2/b.html', e.attributes['href'])
		
		# to same level
		elem = fac.search_element(doc, 'test2/b.html')
		e = fac.choose_next(elem)
		assert_equal('test2/c.html', e.attributes['href'])
		
		# to parent-next
		elem = fac.search_element(doc, 'test2/c.html')
		e = fac.choose_next(elem)
		assert_equal('test3/a.html', e.attributes['href'])
		
		# two levels jump
		elem = fac.search_element(doc, 'test3/c.html')
		e = fac.choose_next(elem)
		assert_equal('d.html', e.attributes['href'])
		
		# last
		elem = fac.search_element(doc, 'test4/c.html')
		assert_nil( fac.choose_next(elem))
	end

	def test_choose_prev
		fac = NavigatorFactory.new('test_resources/sitemap_test1/toc.xml')
		doc = fac.doc
		
		# to children
		elem = fac.search_element(doc, 'test1/a.html')
		e = fac.choose_prev(elem)
		assert_equal('c.html', e.attributes['href'])
		
		# to same level
		elem = fac.search_element(doc, 'test2/c.html')
		e = fac.choose_prev(elem)
		assert_equal('test2/b.html', e.attributes['href'])
		
		# to parent-next
		elem = fac.search_element(doc, 'test2/b.html')
		e = fac.choose_prev(elem)
		assert_equal('test1/a.html', e.attributes['href'])
		
		# two levels jump
		elem = fac.search_element(doc, 'd.html')
		e = fac.choose_prev(elem)
		assert_equal('test3/c.html', e.attributes['href'])
		
		# last
		elem = fac.search_element(doc, 'home.html')
		assert_nil( fac.choose_prev(elem))
	end

	def test_create_navi
		fac = NavigatorFactory.new('test_resources/sitemap_test1/toc.xml')
		doc = fac.doc
		
		navi = fac.create_from_path('test3/c.html')

		assert_equal( '../home.html', navi['start_url'] )
		assert_equal( 'Home PAGE', navi['start_title'] )

		assert_equal( '../a.html', navi['chapter_url'] )
		assert_equal( 'A PAGE', navi['chapter_title'] )

		assert_equal( 'a.html', navi['section_url'] )
		assert_equal( '3-A PAGE', navi['section_title'] )

		assert_equal( 'c.html', navi['subsection_url'] )
		assert_equal( '3-C PAGE', navi['subsection_title'] )

		assert_nil( navi['subsubsection_title'] )
		assert_nil( navi['subsubsection_url'] )

		assert_nil( navi['subsubsubsection_title'] )
		assert_nil( navi['subsubsubsection_url'] )

		assert_equal( '3-A PAGE', navi['up_title'] )
		assert_equal( 'a.html', navi['up_url'] )

		assert_equal( 'D PAGE', navi['next_title'] )
		assert_equal( '../d.html', navi['next_url'] )

		assert_equal( '3-A PAGE', navi['prev_title'] )
		assert_equal( 'a.html', navi['prev_url'] )
	end

end
