# $Id: navigation.rb,v 1.1 2004/01/17 12:02:32 hn Exp $
# Copyright Narushima Hironori. All rights reserved.

require 'rexml/document'
require 'rexml/streamlistener'
require 'net/http'
require 'uri'

=begin

NavigatorFactory#create_navi returns Hash instance that keys are below:

=end
module SiteMapper

module_function

def to_rel(base, target)
	sep = /#{File::SEPARATOR}+/o
	base = base.split(sep)
	base.pop
	target = target.split(sep)
	while base.first == target.first
		base.shift
		target.shift
	end
	File.join([".."]*base.size+target)
end

def choose_title(current_dir, url)
	file = File.join(current_dir, url)
	begin
		lines = if File.file? file
			IO.readlines(file).join
		else
			Net::HTTP.version_1_2
			url = URI.parse url
			Net::HTTP.start(url.host) { |http|
				r = http.get(url.path)
				r.code.to_i < 300 ? r.body : nil
			}
		end
		
		%r!<title.*>(.+?)</title>!mi === lines ? $1 : nil
	rescue
		nil
	end
end

class NavigatorFactory

	def initialize( docpath)
		@hierarchy_names = %w!start chapter section subsection subsubsection subsubsubsection!
		@docpath = docpath
		@doc = REXML::Document.new( File.new(docpath) )
	end

	attr_reader :doc

	def create_from_path( path)
		path.gsub!(/^\/+/, '')
		elem = search_element( @doc, path)
		create_navi( elem) if elem
	end

	def search_element(elem, path)
		elem.each_element { |e|
			p = e.attributes['href']
			return e if p == path
			
			e = search_element(e, path)
			return e if e
		}
		nil
	end

	def create_navi( elem)
		hash = {
			'next' => choose_next(elem),
			'prev' => choose_prev(elem),
			'up' => (parent = elem.parent and parent.name == 'topic') ? parent : nil,
		}
		
		hierarchy = []
		e = elem
		begin
			hierarchy << e
		end while (e = e.parent) and (e.name == 'topic')
		
		@hierarchy_names.each { |k|
			hash[k] = hierarchy.pop
		}
		myurl = elem.attributes['href']
		
		hash.dup.each { |k, v|
			if v 
				if org_target = v.attributes['href']
					hash["#{k}_url"] = (%r!^.*://! === org_target) ?
						org_target : SiteMapper.to_rel( myurl, org_target)
				end
				unless title = v.attributes['label']
					title = SiteMapper.choose_title(File.dirname(@docpath), org_target) if org_target
				end
				hash["#{k}_title"] = title
			end
			hash.delete(k)
		}
		hash
	end
	
	def choose_next(elem)
		next_elem = nil
		
		if elem.has_elements?
			next_elem = elem.elements[1]
		elsif e = elem.next_element
			next_elem = e
		else
			while elem = elem.parent
				if ne = elem.next_element
					next_elem = ne
					break
				end
			end
		end
		
		if next_elem
			attrs = next_elem.attributes
			if attrs['label'] and !attrs['href']
				return choose_next(next_elem)
			end
		end
		
		next_elem
	end
	
	def choose_prev(elem)
		prev_elem = nil
		
		if prev = elem.previous_element
			begin
				if !prev.has_elements?
					prev_elem = prev
					break
				end
			end while prev = prev.elements.to_a.last
		else
			p = elem.parent
			prev_elem = p if p.name == 'topic'
		end
		
		if prev_elem
			attrs = prev_elem.attributes
			if attrs['label'] and !attrs['href']
				return choose_prev(prev_elem)
			end
		end
		
		prev_elem
	end
	
end

end
