# $Id: generation_test.rb,v 1.1 2004/01/17 12:02:32 hn Exp $
# Copyright Narushima Hironori. All rights reserved.

project_dir = File.dirname(__FILE__).sub(/(com.narucy.webpub.core).+/, '\1')
Dir.chdir project_dir
$: << project_dir + '/scripts/lib'

require 'test/unit'
require 'sitemapper/generator'

class NavigationTest < Test::Unit::TestCase

	include SiteMapper

	def test_generate
		gene = SitemapGenerator.new
		
		code = gene.gen('test_resources/sitemap_test1/toc.xml')
		assert(%r!<a href="home.html"></a>! === code)
		
		error = nil
		begin
			code = gene.gen('test_resources/sitemap_test1/toc.xml', 'foo')
		rescue ArgumentError => e
			error = e
		end
		
		code = gene.gen('test_resources/sitemap_test1/toc.xml', 'test1/a.html')
		assert( !(%r[<a href="home.html"></a>] === code))
	end

end
