#!/usr/local/bin/ruby

#
# $Id: pubtool_test.rb,v 1.1 2004/01/17 12:02:25 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

project_dir = File.dirname(__FILE__).sub(/(com.narucy.webpub.core).+/, '\1')
if $CYGWIN = (/cygwin$/ === RUBY_PLATFORM)
	require File.join(File.dirname(__FILE__), 'cygpath.rb')
	project_dir = Cygwin::cygpath(project_dir)
end

p project_dir + '/scripts/lib'

Dir.chdir project_dir
$: << project_dir + '/scripts/lib'

$libdir = File.join( File.dirname(__FILE__), '../lib/webpub')

require 'test/unit'
require 'webpub/rftools'

class PubToolTest < Test::Unit::TestCase

	def setup
		@proj_location = File.dirname(__FILE__) + '/../../test_resources/webproject001'
		@tmpdir = ENV['TEMP'] + '/pubtool_test'
		
		File.rm_all(@tmpdir) if File.exist?(@tmpdir)

		File.cp_all(@proj_location, @tmpdir)

		@plugin_properties = ENV['TEMP'] + '/plugin_properties'
		open(@plugin_properties, 'w') { |fh|
			fh << ['amrita', "#{$libdir}/amrita_publisher.rb", 'WebPub::AmritaPublisher'].join(',')
		}
		@interpreter = "c:/cygwin/usr/local/bin/ruby"
	end
	
	def test_publish_to_other_folder
		tmp_workspace = File.join( ENV['TEMP'], 'virtual_workspace')
		File.rm_all(tmp_workspace) if File.exist?(tmp_workspace)
		begin
			File.cp_all('test_resources/virtual_workspace', tmp_workspace)
			proj_file =  File.join(@tmpdir, '.webproject')
			lines = IO.readlines(proj_file).map { |l|
				l.gsub(/public_html/, '/xxx')
			}.join
			open(proj_file, 'w') { |fh| fh << lines }
			
			files = [
				@tmpdir + '/ht_sources/home.html',
				@tmpdir + '/ht_sources/home2.html',
				@tmpdir + '/ht_sources/home3.html',
			]
			
			command = "#{File.dirname(__FILE__)}/pubtool.rb --workspace #{tmp_workspace} --plugin_properties #{@plugin_properties} --build_order amrita --files #{files.join(',')}"
			`#{@interpreter} #{command}`
			
			d = 'c:/temp/tmp_xxx'
			assert %r!2001/01/01! === IO.readlines( d + '/home.html').join
			assert %r!2002/02/02! === IO.readlines( d + '/home2.html').join
			assert %r!2003/03/03! === IO.readlines( d + '/foo/home.html').join
		ensure
			# File.rm_all(tmp_workspace)
		end
	end

	def _test_publish_by_amrita
		files = [
			@tmpdir + '/ht_sources/home.html',
			@tmpdir + '/ht_sources/home2.html',
			@tmpdir + '/ht_sources/home3.html',
		]
		
		command = "#{File.dirname(__FILE__)}/pubtool.rb --plugin_properties #{@plugin_properties} --build_order amrita --files #{files.join(',')}"
		puts `#{@interpreter} #{command}`
		
		assert %r!2001/01/01! === IO.readlines( @tmpdir + '/public_html/home.html').join
		assert %r!2002/02/02! === IO.readlines( @tmpdir + '/public_html/home2.html').join
		assert %r!2003/03/03! === IO.readlines( @tmpdir + '/public_html/foo/home.html').join
	end

	def teardown
		File.delete @plugin_properties
		File.rm_all @tmpdir
	end

end
