#!/usr/local/bin/ruby

#
# $Id: pubtool.rb,v 1.1 2004/01/17 12:02:25 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

dir = File::dirname(File::expand_path(__FILE__))
if $CYGWIN = (/cygwin$/ === RUBY_PLATFORM)
	require File.join( dir, 'cygpath.rb')
	dir = Cygwin::cygpath(dir)
end
$: << File.expand_path( File.join(dir, '..' , 'lib') )

require 'webpub/publish_manager'

def mygetopts(argv)
	hash = {
		'workspace' => nil,
		'plugin_properties' => nil,
		'build_order' => nil,
		'files' => nil
	}
	while v = argv.shift
		if /^--(.+)/ === v and hash.key? $1
			 hash[$1] = argv.shift
		end
	end
	
	hash
end

if __FILE__ == $0
	opts = mygetopts(ARGV)
	pp = opts['plugin_properties']
	files = opts['files'].split(',')
	$WORKSPACE_PATH = opts['workspace']
	
	WebPub::PublishManager.new(pp).publish(files)	
end