/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.wizards;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.WebResourceLinkModel;
import com.narucy.webpub.core.WebResourceSelectionListener;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;

public class WebResourceSelectionBlock {
    final WebResourceLinkModel model;
    final IContainer publishFolder;
    Label labe;
    Button toAbsolute;
    Text hrefText;

    public WebResourceSelectionBlock(IResource res) throws CoreException {
        this(res.getParent());
    }

    public WebResourceSelectionBlock(IContainer container) throws CoreException {
        this.model = new WebResourceLinkModel(container);
        this.publishFolder = ((WebProject)container.getProject().getNature("com.narucy.webpub.core.publishNature")).getFolder("publish_folder");
    }

    public Control createControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        base.setLayout((Layout)gl);
        this.labe = new Label(base, 0);
        this.labe.setText("&URL:");
        GridData gd = new GridData();
        this.labe.setLayoutData((Object)gd);
        this.hrefText = new Text(base, 2052);
        this.hrefText.setLayoutData((Object)new GridData(768));
        this.hrefText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebResourceSelectionBlock.this.model.setPath(WebResourceSelectionBlock.this.hrefText.getText());
            }
        });
        Button browse = new Button(base, 8);
        browse.setText("B&rowse...");
        browse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WebResourceSelectionBlock.this.callResourceSelectionDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(base, 0);
        this.toAbsolute = new Button(base, 32);
        this.toAbsolute.setText("&Convert link target to absolute in web project");
        this.toAbsolute.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WebResourceSelectionBlock.this.model.setAbsolute(WebResourceSelectionBlock.this.toAbsolute.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(base, 0);
        this.model.addListener(new WebResourceSelectionListener(){

            public void resourceChanged(IPath path, IResource existResource) {
                if (!path.toString().equals(WebResourceSelectionBlock.this.hrefText.getText())) {
                    WebResourceSelectionBlock.this.hrefText.setText(path.toString());
                }
                boolean absEnabled = WebResourceSelectionBlock.this.model.getWebResource() != null;
                WebResourceSelectionBlock.this.toAbsolute.setEnabled(absEnabled);
                WebResourceSelectionBlock.this.toAbsolute.setSelection(absEnabled && WebResourceSelectionBlock.this.model.isAbsolute());
            }

            public void statusChanged(IStatus status) {
            }
        });
        return base;
    }

    void callResourceSelectionDialog() {
        ResourceSelectionDialog dialog = new ResourceSelectionDialog(this.labe.getShell(), (IAdaptable)this.publishFolder, null);
        IResource currentSelectionResource = this.model.getWebResource();
        if (currentSelectionResource != null && !(this.publishFolder instanceof IProject)) {
            dialog.setInitialSelections(new Object[]{currentSelectionResource});
        }
        if (dialog.open() == 0) {
            this.model.setWebResource((IResource)dialog.getResult()[0]);
        }
    }

    void p(Object o) {
        System.out.println(this.getClass() + ":" + o);
    }

    public void setColumnNameWidth(int colNameWidth) {
        ((GridData)this.labe.getLayoutData()).widthHint = colNameWidth;
    }

    public void forceFocus() {
        this.hrefText.forceFocus();
    }

    public WebResourceLinkModel getModel() {
        return this.model;
    }
}

