/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.wizards;

import com.narucy.webpub.core.HTMLUtilities;
import com.narucy.webpub.ui.wizards.EditElementWizardPage;
import com.narucy.webpub.ui.wizards.SomeItemInputDialog;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class UnknownElementWizardPage
extends EditElementWizardPage {
    static final String NAME = "ColumnProperty-name";
    static final String VALUE = "ColumnProperty-value";
    Button emptyElementCheck;
    Button addButton;
    Button removeButton;
    Button upButton;
    Button downButton;
    TableViewer unknownElementAttrs;
    ArrayList attrs = new ArrayList();
    ArrayList listeners = new ArrayList();
    SelectionListener elemTypeChangeListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            UnknownElementWizardPage.this.refreshPreview();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    static IInputValidator attrValidator = new IInputValidator(){

        public String isValid(String newText) {
            if (newText.length() == 0) {
                return "Need to specify name";
            }
            if (newText.indexOf(32) != -1 || newText.indexOf(10) != -1 || newText.indexOf(9) != -1) {
                return "Not contain blank";
            }
            return null;
        }
    };

    public UnknownElementWizardPage() {
        super("UnknownElementEditPage");
        this.setTitle("Unknown");
        this.setDescription("Editor for any HTML element.");
    }

    protected void createChildControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        Label labe = new Label(parent, 0);
        labe.setText("Element &Attribute:");
        GridData gd = new GridData(32);
        labe.setLayoutData((Object)gd);
        new Label(parent, 0);
        this.unknownElementAttrs = new TableViewer(parent, 67588);
        gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.verticalSpan = 4;
        this.unknownElementAttrs.getControl().setLayoutData((Object)gd);
        Table table = this.unknownElementAttrs.getTable();
        new TableColumn(table, 16384).setText("Name");
        new TableColumn(table, 16384).setText("Value");
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.unknownElementAttrs.setColumnProperties(new String[]{NAME, VALUE});
        this.unknownElementAttrs.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.unknownElementAttrs.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)});
        this.unknownElementAttrs.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                return ((String[])element)[property.equals(UnknownElementWizardPage.NAME) ? 0 : 1];
            }

            public void modify(Object element, String property, Object value) {
                if (element instanceof Item) {
                    ((String[])((Item)element).getData())[property.equals((Object)UnknownElementWizardPage.NAME) ? 0 : 1] = HTMLUtilities.unescape((String)((String)value));
                    UnknownElementWizardPage.this.refreshPreview();
                }
            }
        });
        this.unknownElementAttrs.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                return ((String[])element)[columnIndex];
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return property.equals(UnknownElementWizardPage.NAME) || property.equals(UnknownElementWizardPage.VALUE);
            }
        });
        this.resetAttributes();
        this.unknownElementAttrs.setInput((Object)this.attrs);
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].pack();
            ++i;
        }
        this.upButton = UnknownElementWizardPage.createButton(parent, "&Up");
        this.upButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = UnknownElementWizardPage.this.getSelectionIndex();
                if (index > 0) {
                    UnknownElementWizardPage.this.attrs.add(index - 1, UnknownElementWizardPage.this.attrs.remove(index));
                    UnknownElementWizardPage.this.refreshPreview();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.downButton = UnknownElementWizardPage.createButton(parent, "&Down");
        this.downButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = UnknownElementWizardPage.this.getSelectionIndex();
                if (index < UnknownElementWizardPage.this.attrs.size() - 1) {
                    UnknownElementWizardPage.this.attrs.add(index + 1, UnknownElementWizardPage.this.attrs.remove(index));
                    UnknownElementWizardPage.this.refreshPreview();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.addButton = UnknownElementWizardPage.createButton(parent, "&Add");
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UnknownElementWizardPage.this.getSelectionIndex();
                String[] newData = this.inputValue();
                if (newData != null) {
                    UnknownElementWizardPage.this.attrs.add(newData);
                    UnknownElementWizardPage.this.refreshPreview();
                }
            }

            String[] inputValue() {
                IInputValidator[] iInputValidatorArray = new IInputValidator[2];
                iInputValidatorArray[0] = attrValidator;
                SomeItemInputDialog dialog = new SomeItemInputDialog(UnknownElementWizardPage.this.getShell(), "Input New Attribute", new String[]{"Attribute name", "Attribute value"}, iInputValidatorArray);
                if (dialog.open() == 0) {
                    String[] values = dialog.getValues();
                    int i = 0;
                    while (i < values.length) {
                        values[i] = values[i];
                        ++i;
                    }
                    return values;
                }
                return null;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeButton = UnknownElementWizardPage.createButton(parent, "&Remove");
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = UnknownElementWizardPage.this.getSelectionIndex();
                if (index != -1) {
                    UnknownElementWizardPage.this.attrs.remove(index);
                    UnknownElementWizardPage.this.refreshPreview();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.emptyElementCheck = new Button(parent, 32);
        gd = new GridData(768);
        this.emptyElementCheck.setLayoutData((Object)gd);
        this.emptyElementCheck.setText("&Empty Element");
        this.emptyElementCheck.addSelectionListener(this.elemTypeChangeListener);
        this.emptyElementCheck.setSelection(this.isEmptyAsText());
        new Label(parent, 0);
    }

    static Button createButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        GridData gd = new GridData(130);
        gd.widthHint = 60;
        button.setLayoutData((Object)gd);
        button.setText(text);
        return button;
    }

    public String getPreviewText() {
        String elemName = this.getElementName();
        if (elemName == null) {
            return null;
        }
        boolean empty = false;
        empty = this.emptyElementCheck == null ? this.isEmptyAsText() : this.emptyElementCheck.getSelection();
        String content = this.getSelectionText();
        if (!empty && this.getEditType() == 1) {
            content = EditElementWizardPage.chooseContent(content);
        }
        String previewText = "<" + elemName + this.attrsCode();
        previewText = empty ? String.valueOf(previewText) + " />" : String.valueOf(previewText) + ">" + content + "</" + elemName + ">";
        return previewText;
    }

    boolean isEmptyAsText() {
        String selText = this.getSelectionText();
        if (this.getEditType() == 1) {
            int len = selText.length();
            return selText.substring(len - 2, len).equals("/>");
        }
        return false;
    }

    void resetAttributes() {
        this.attrs.clear();
        Element elem = this.getParsedSelectionText();
        if (elem != null) {
            NamedNodeMap as = elem.getAttributes();
            int i = 0;
            while (i < as.getLength()) {
                Node n = as.item(i);
                this.attrs.add(new String[]{n.getNodeName(), n.getNodeValue()});
                ++i;
            }
        }
    }

    String attrsCode() {
        StringBuffer buff = new StringBuffer();
        Object[] as = this.attrs.toArray();
        int i = 0;
        while (i < as.length) {
            String[] a = (String[])as[i];
            buff.append(" " + a[0] + "=\"" + HTMLUtilities.escape((String)a[1]) + "\"");
            ++i;
        }
        return buff.toString();
    }

    int getSelectionIndex() {
        ISelection sel = this.unknownElementAttrs.getSelection();
        if (sel instanceof IStructuredSelection) {
            Object item = ((IStructuredSelection)sel).getFirstElement();
            return this.attrs.indexOf(item);
        }
        return -1;
    }

    public void refreshPreview() {
        this.unknownElementAttrs.refresh();
        super.refreshPreview();
    }

    public void setElementName(String elemName) {
        super.setElementName(elemName);
        this.setTitle("\"" + elemName + "\" Element");
    }
}

