/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.wizards;

import com.narucy.webpub.core.template.Template;
import com.narucy.webpub.core.template.TemplateManager;
import com.narucy.webpub.ui.wizards.IPreviewer;
import com.narucy.webpub.ui.wizards.InsertTemplateWizard;
import com.narucy.webpub.ui.wizards.TemplateContentSelectionWizardPage;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class TemplateNameInputWizardPage
extends WizardPage
implements IPreviewer {
    static IInputValidator validator = new IInputValidator(){

        public String isValid(String str) {
            if (!Pattern.matches("^\\w+$", str)) {
                return "Template name must be english characters.";
            }
            return null;
        }
    };
    Combo tmplsCombo;
    Text preview;
    String tmplName;
    boolean flipToNext = false;

    public TemplateNameInputWizardPage() {
        super("InsertTemplateWizardPage");
        this.setTitle("Insert Template");
        this.setDescription("Insert Template, already created template or new template.");
    }

    public void createControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        this.setControl((Control)base);
        base.setLayout((Layout)new GridLayout(2, false));
        new Label(base, 0).setText("T&emplate name:");
        this.tmplsCombo = new Combo(base, 2048);
        this.tmplsCombo.setLayoutData((Object)new GridData(768));
        this.tmplsCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TemplateNameInputWizardPage.this.templateSelection();
            }
        });
        this.preview = InsertTemplateWizard.createPreview(base);
        Template[] globalTmpls = ((InsertTemplateWizard)this.getWizard()).getTemplateManager().getGlobalTemplates();
        int i = 0;
        while (i < globalTmpls.length) {
            this.tmplsCombo.add(globalTmpls[i].getName());
            ++i;
        }
        this.tmplsCombo.forceFocus();
    }

    void templateSelection() {
        this.tmplName = this.tmplsCombo.getText();
        String errResult = validator.isValid(this.tmplName);
        this.setErrorMessage(errResult);
        TemplateManager tmplMgr = ((InsertTemplateWizard)this.getWizard()).getTemplateManager();
        this.flipToNext = false;
        if (tmplMgr.isContainGlobalTemplate(this.tmplName)) {
            Template t = tmplMgr.getGlobalTemplate(this.tmplName);
            this.preview.setText(t.getJoinedLines());
            ((TemplateContentSelectionWizardPage)this.getNextPage()).setTemplateName(this.tmplName);
            if (TemplateNameInputWizardPage.isContentsIncluded(t)) {
                this.flipToNext = true;
            }
        } else {
            this.updateTemplateName();
        }
        this.getWizard().getContainer().updateButtons();
    }

    static boolean isContentsIncluded(Template tmpl) {
        if (tmpl.getName().equals("CONTENTS")) {
            return true;
        }
        Template[] ts = tmpl.getChildrenTemplates();
        int i = 0;
        while (i < ts.length) {
            if (TemplateNameInputWizardPage.isContentsIncluded(ts[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage() && this.flipToNext;
    }

    void updateTemplateName() {
        if (this.getErrorMessage() == null) {
            StringBuffer buff = new StringBuffer();
            String content = ((InsertTemplateWizard)this.getWizard()).getTextSelection().getText();
            buff.append("<!-- $begin:" + this.tmplName + "$ -->");
            if (content.length() > 0 && content.charAt(0) != '\n') {
                buff.append('\n');
            }
            buff.append(content);
            if (content.length() <= 0 || content.charAt(content.length() - 1) != '\n') {
                buff.append('\n');
            }
            buff.append("<!-- $end:" + this.tmplName + "$ -->\n");
            this.preview.setText(buff.toString());
        } else {
            this.preview.setText("");
        }
    }

    void p(Object o) {
        System.out.println(this.getClass() + ":" + o);
    }

    public String getPreviewText() {
        return this.preview != null ? this.preview.getText().replaceAll("\r", "") : null;
    }
}

