/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.wizards;

import com.narucy.webpub.core.ElementWriter;
import com.narucy.webpub.ui.wizards.StringDivider;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class TableElementModel {
    static final char[] CHAR_TABLE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    ElementWriter writer;
    DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
    Document document;
    Element tableElement;
    String[] columnProperties;
    static /* synthetic */ Class class$0;

    public TableElementModel(String content, boolean parse) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (parse) {
            this.initAsParse(content);
        } else {
            this.initModel(content);
        }
        this.columnProperties = this.createColumnProperties();
        this.writer = new ElementWriter(0, null);
        this.writer.setExpandOption("caption", 2);
        this.writer.setExpandOption("table", 3);
        this.writer.setExpandOption("thead", 3);
        this.writer.setExpandOption("tfoot", 3);
        this.writer.setExpandOption("tbody", 3);
        this.writer.setExpandOption("tr", 2);
    }

    static void p(Object o) {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.narucy.webpub.ui.wizards.TableElementModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        System.out.println(stringBuffer.append(clazz).append(":").append(o).toString());
    }

    void initModel(String content) throws ParserConfigurationException, SAXException, IOException {
        StringReader strReader = new StringReader(content);
        InputSource inputSrc = new InputSource(strReader);
        this.document = this.docBuilder.parse(inputSrc);
        this.tableElement = this.document.getDocumentElement();
        Element[] rows = this.getRows();
        int i = 0;
        while (i < rows.length) {
            Element[] cells = TableElementModel.chooseCellElements(rows[i]);
            int j = 0;
            while (j < cells.length) {
                Element cell = cells[j];
                if (!cell.hasChildNodes()) {
                    cell.appendChild(this.document.createTextNode(""));
                }
                ++j;
            }
            ++i;
        }
    }

    public void initAsParse(String content) throws ParserConfigurationException, FactoryConfigurationError {
        this.document = this.docBuilder.newDocument();
        this.tableElement = this.document.createElement("table");
        String[][] cells = StringDivider.divide(content);
        if (cells.length > 0) {
            int i = 0;
            while (i < cells.length) {
                String[] rows = cells[i];
                Element tr = this.document.createElement("tr");
                int j = 0;
                while (j < rows.length) {
                    Element e = this.document.createElement("td");
                    e.appendChild(this.document.createTextNode(rows[j]));
                    tr.appendChild(e);
                    ++j;
                }
                this.tableElement.appendChild(tr);
                ++i;
            }
            this.setColumnCount(cells[0].length);
        } else {
            Element tr = this.document.createElement("tr");
            Element td = this.document.createElement("td");
            td.appendChild(this.document.createTextNode(""));
            tr.appendChild(td);
            this.tableElement.appendChild(tr);
            this.setColumnCount(1);
        }
    }

    String[] createColumnProperties() {
        int len = this.getColumnCount();
        String[] props = new String[len];
        int i = 0;
        while (i < len) {
            props[i] = TableElementModel.toColumnName(i);
            ++i;
        }
        return props;
    }

    public void setRowCount(int rowCount) {
        block3: {
            Element[] rows;
            block2: {
                rows = this.getRows();
                if (rowCount <= rows.length) break block2;
                int i = rows.length;
                while (i < rowCount) {
                    this.tableElement.appendChild(this.createRowElement());
                    ++i;
                }
                break block3;
            }
            if (rowCount >= rows.length) break block3;
            int i = rowCount;
            while (i < rows.length) {
                this.tableElement.removeChild(rows[i]);
                ++i;
            }
        }
    }

    public Element[] getRows() {
        ArrayList<Node> rows = new ArrayList<Node>();
        NodeList nodes = this.tableElement.getElementsByTagName("tr");
        int i = 0;
        while (i < nodes.getLength()) {
            rows.add(nodes.item(i));
            ++i;
        }
        return rows.toArray(new Element[rows.size()]);
    }

    public int getRowCount() {
        return this.getRows().length;
    }

    Element createRowElement() {
        Element tr = this.document.createElement("tr");
        int i = 0;
        int columnCount = this.getColumnCount();
        while (i < columnCount) {
            Element td = this.document.createElement("td");
            td.appendChild(this.document.createTextNode(""));
            tr.appendChild(td);
            ++i;
        }
        return tr;
    }

    public void setColumnCount(int newLength) {
        NodeList trs = this.tableElement.getElementsByTagName("tr");
        int i = 0;
        while (i < trs.getLength()) {
            int j;
            Element tr = (Element)trs.item(i);
            Element[] cells = TableElementModel.chooseCellElements(tr);
            int colLen = cells.length;
            if (newLength > colLen) {
                j = 0;
                int len = newLength - colLen;
                while (j < len) {
                    Element cell = this.document.createElement("td");
                    cell.appendChild(this.document.createTextNode(""));
                    tr.appendChild(cell);
                    ++j;
                }
            } else if (newLength < colLen) {
                j = newLength;
                while (j < colLen) {
                    tr.removeChild(cells[j]);
                    ++j;
                }
            }
            ++i;
        }
        this.columnProperties = this.createColumnProperties();
    }

    public int getColumnCount() {
        NodeList trs = this.tableElement.getElementsByTagName("tr");
        if (trs.getLength() > 0) {
            Element tr = (Element)trs.item(0);
            return TableElementModel.chooseCellElements(tr).length;
        }
        return 0;
    }

    public static Element[] chooseCellElements(Element tr) {
        NodeList nodeList = tr.getChildNodes();
        ArrayList<Node> result = new ArrayList<Node>();
        int i = 0;
        while (i < nodeList.getLength()) {
            String nodeName;
            Node node = nodeList.item(i);
            if (node instanceof Element && ((nodeName = node.getNodeName()).equals("td") || nodeName.equals("th"))) {
                result.add(node);
            }
            ++i;
        }
        return result.toArray(new Element[result.size()]);
    }

    public String expandCodes() {
        return this.writer.expandTag(this.tableElement);
    }

    protected static String toColumnName(int i) {
        StringBuffer buff = new StringBuffer();
        int u = i / CHAR_TABLE.length;
        if (u > 0) {
            buff.append(CHAR_TABLE[u - 1]);
        }
        buff.append(CHAR_TABLE[i % CHAR_TABLE.length]);
        return buff.toString();
    }

    protected static int toNumeric(String code) {
        int result = -1;
        int i = 0;
        while (i < code.length()) {
            char c = code.charAt(i);
            int match = Arrays.binarySearch(CHAR_TABLE, c);
            if (match >= 0) {
                if (result == -1) {
                    result = 0;
                }
                int v = match;
                int u = code.length() - 1 - i;
                if (u > 0) {
                    v = CHAR_TABLE.length * u * (v + 1);
                }
                result += v;
            }
            ++i;
        }
        return result;
    }

    public void move(Element tr, int moveCount) {
        Element[] rows = this.getRows();
        int index = -1;
        int i = 0;
        while (i < rows.length) {
            if (tr.equals(rows[i])) {
                index = i;
            }
            ++i;
        }
        if (index == -1) {
            throw new IllegalArgumentException("Invalid row node (not countained in this table):" + tr);
        }
        if (moveCount > 0) {
            i = index;
            while (i < moveCount + index && i < rows.length - 1) {
                this.tableElement.insertBefore(rows[i + 1], rows[i]);
                ++i;
            }
        } else if (moveCount < 0) {
            i = index;
            while (i >= moveCount + index + 1 && i >= 1) {
                this.tableElement.insertBefore(rows[index], rows[i - 1]);
                --i;
            }
        } else {
            return;
        }
    }

    public void insertNewRowBefore(Element tr) {
        Element newRow = this.createRowElement();
        if (tr == null) {
            this.tableElement.appendChild(newRow);
        } else {
            this.tableElement.insertBefore(newRow, tr);
        }
    }

    public void removeRow(Element tr) {
        this.tableElement.removeChild(tr);
    }

    public String[] getColumnProperties() {
        return (String[])this.columnProperties.clone();
    }
}

