/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.wizards;

import com.narucy.webpub.ui.wizards.TableElementModel;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.Item;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TableElementCellModifier
implements ICellModifier {
    DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
    IPropertyChangeListener listener;

    public TableElementCellModifier(IPropertyChangeListener listener) {
        this.listener = listener;
    }

    public boolean canModify(Object element, String property) {
        return this.getValue(element, property) != null;
    }

    public Object getValue(Object trElem, String property) {
        Element e;
        if (trElem instanceof Element && (e = (Element)trElem).getNodeName().equals("tr")) {
            Node n;
            NodeList nodes;
            int v = TableElementModel.toNumeric(property);
            Element[] cells = TableElementModel.chooseCellElements(e);
            if (v >= 0 && v < cells.length && (nodes = cells[v].getChildNodes()).getLength() == 1 && (n = nodes.item(0)) instanceof Text) {
                return n.getNodeValue();
            }
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        if (element instanceof Item) {
            element = ((Item)element).getData();
        }
        Element trElem = (Element)element;
        int index = TableElementModel.toNumeric(property);
        Element cellElem = TableElementModel.chooseCellElements(trElem)[index];
        NodeList nodes = cellElem.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            cellElem.removeChild(nodes.item(i));
            ++i;
        }
        Document doc = cellElem.getOwnerDocument();
        if (value instanceof String) {
            cellElem.appendChild(doc.createTextNode((String)value));
        }
        if (this.listener != null) {
            String oldValue = nodes.item(0).getNodeValue();
            this.listener.propertyChange(new PropertyChangeEvent((Object)this, property, (Object)((String)value), (Object)oldValue));
        }
    }
}

