/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.wizards;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.wizards.InitialWebPageWizardPage;
import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewWebPageWizard
extends BasicNewResourceWizard {
    WizardNewFileCreationPage newFilePage;
    InitialWebPageWizardPage newPageSelectionPage;

    public NewWebPageWizard() {
        this.setWindowTitle("New Web Page");
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        try {
            IResource res = (IResource)this.getSelection().getFirstElement();
            WebProject webProj = (WebProject)res.getProject().getNature("com.narucy.webpub.core.publishNature");
            String[] htExtensions = webProj.getArray("ht_extensions");
            IInputValidator validator = NewWebPageWizard.createHTFileValidator(htExtensions);
            this.newFilePage = new NewHTFileCreationPage(this.getSelection(), validator);
            this.addPage((IWizardPage)this.newFilePage);
            IContainer folder = webProj.getFolder("htsources_folder");
            this.newPageSelectionPage = new InitialWebPageWizardPage(folder, validator);
            this.addPage((IWizardPage)this.newPageSelectionPage);
        }
        catch (CoreException e) {
            WebpubUIPlugin.handleException((Exception)((Object)e));
        }
        ImageDescriptor pageImgDesc = WebpubUIPlugin.getDefault().getImageDescriptor("wizban/newwebpage_wiz.gif");
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            pages[i].setImageDescriptor(pageImgDesc);
            ++i;
        }
    }

    static IInputValidator createHTFileValidator(String[] htExts) {
        Object[] htExtensions = (String[])htExts.clone();
        Arrays.sort(htExtensions);
        return new IInputValidator((String[])htExtensions){
            private final /* synthetic */ String[] val$htExtensions;
            {
                this.val$htExtensions = stringArray;
            }

            public String isValid(String fileName) {
                int dotIndex = fileName.lastIndexOf(46);
                if (dotIndex == -1) {
                    return "Need to specify extension.";
                }
                String ext = fileName.substring(dotIndex + 1);
                if (Arrays.binarySearch(this.val$htExtensions, ext) < 0) {
                    return "Specify text is not representation html file.";
                }
                return null;
            }
        };
    }

    public boolean performFinish() {
        IFile file = this.newFilePage.createNewFile();
        this.selectAndReveal((IResource)file);
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        try {
            IWorkbenchPage page;
            if (window != null && (page = window.getActivePage()) != null) {
                page.openEditor(file);
            }
        }
        catch (PartInitException partInitException) {}
        this.newPageSelectionPage.distributeSettings();
        return true;
    }

    class NewHTFileCreationPage
    extends WizardNewFileCreationPage {
        IInputValidator validator;

        NewHTFileCreationPage(IStructuredSelection sel, IInputValidator validator) {
            super("NewHTFileCreationPage", sel);
            this.setDescription("Enter the required data to generate website source files");
            this.validator = validator;
        }

        protected InputStream getInitialContents() {
            IFile file = NewWebPageWizard.this.newPageSelectionPage.getResult();
            if (file != null) {
                try {
                    return file.getContents();
                }
                catch (CoreException e) {
                    WebpubUIPlugin.handleException((Exception)((Object)e));
                }
            }
            return null;
        }

        protected boolean validatePage() {
            String errMsg = this.validator.isValid(this.getFileName());
            if (errMsg != null) {
                this.setErrorMessage(errMsg);
                return false;
            }
            return super.validatePage();
        }
    }
}

