/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.wizards;

import com.narucy.webpub.core.template.TemplateManager;
import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.wizards.IPreviewer;
import com.narucy.webpub.ui.wizards.TemplateContentSelectionWizardPage;
import com.narucy.webpub.ui.wizards.TemplateNameInputWizardPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class InsertTemplateWizard
extends Wizard {
    ITextEditor editor;
    TemplateManager tmplMgr;

    protected static Text createPreview(Composite parent) {
        InsertTemplateWizard.createPreviewLabel(parent);
        return InsertTemplateWizard.createPreviewText(parent);
    }

    protected static Label createPreviewLabel(Composite parent) {
        Label labe = new Label(parent, 0);
        labe.setText("Preview:");
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        labe.setLayoutData((Object)gd);
        return labe;
    }

    protected static Text createPreviewText(Composite parent) {
        Text preview = new Text(parent, 2826);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        preview.setLayoutData((Object)gd);
        return preview;
    }

    public InsertTemplateWizard(ITextEditor editor) throws CoreException {
        this.editor = editor;
        IFile f = ((IFileEditorInput)editor.getEditorInput()).getFile();
        this.tmplMgr = TemplateManager.getManagerInstance((IProject)f.getProject());
        this.setWindowTitle("Insert Template");
        this.setDefaultPageImageDescriptor(WebpubUIPlugin.getDefault().getImageDescriptor("wizban/inserttmpl_wiz.gif"));
        this.addPage((IWizardPage)new TemplateNameInputWizardPage());
        this.addPage((IWizardPage)new TemplateContentSelectionWizardPage());
    }

    public TemplateManager getTemplateManager() {
        return this.tmplMgr;
    }

    public boolean performFinish() {
        try {
            this.doInsertTemplate((IPreviewer)this.getContainer().getCurrentPage());
        }
        catch (BadLocationException e) {
            WebpubUIPlugin.handleException((Exception)((Object)e));
        }
        return true;
    }

    void doInsertTemplate(IPreviewer page) throws BadLocationException {
        ITextSelection sel = this.getTextSelection();
        int offset = sel.getOffset();
        int len = sel.getLength();
        IDocument doc = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        StringBuffer preview = new StringBuffer();
        if (doc.getChar(offset) != '\n') {
            preview.append('\n');
        }
        preview.append(page.getPreviewText());
        int endIndex = offset + len;
        if (doc.getLength() > endIndex && doc.getChar(endIndex) != '\n') {
            preview.append('\n');
        }
        doc.replace(offset, len, preview.toString());
        this.editor.getSelectionProvider().setSelection((ISelection)new TextSelection(offset + preview.length(), 0));
    }

    protected ITextSelection getTextSelection() {
        return (ITextSelection)this.editor.getSelectionProvider().getSelection();
    }
}

