/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.views;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.toc.Toc;
import com.narucy.webpub.core.toc.TocEvent;
import com.narucy.webpub.core.toc.TocListener;
import com.narucy.webpub.core.toc.Topic;
import com.narucy.webpub.ui.WebpubUIPlugin;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class TocContentProvider
implements ITreeContentProvider {
    AbstractTreeViewer viewer;
    HashMap listenersCache = new HashMap();
    WorkbenchContentProvider workbenchContentProvider = new WorkbenchContentProvider();

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.workbenchContentProvider.inputChanged(viewer, oldInput, newInput);
        this.viewer = (AbstractTreeViewer)viewer;
    }

    public Object[] getChildren(Object parentElem) {
        try {
            if (parentElem instanceof IProject) {
                return this.getProjectChildren((IProject)parentElem);
            }
            if (parentElem instanceof Topic) {
                return ((Topic)parentElem).getSubtopics();
            }
        }
        catch (CoreException e) {
            WebpubUIPlugin.handleException((Exception)((Object)e));
        }
        return null;
    }

    Object[] getProjectChildren(IProject proj) throws CoreException {
        WebProject wp = (WebProject)proj.getNature("com.narucy.webpub.core.publishNature");
        if (wp == null) {
            return null;
        }
        IFile[] files = wp.getTocFiles();
        Object[] children = new Object[files.length];
        int i = 0;
        while (i < files.length) {
            IFile f = files[i];
            Toc toc = wp.getToc(f);
            Object object = children[i] = toc != null ? toc : f;
            if (toc != null && !this.listenersCache.containsKey(toc)) {
                TocListener listener = new TocListener(){

                    public void topicChanged(TocEvent[] events) {
                        TocContentProvider.this.viewer.refresh();
                    }
                };
                toc.addTocListener(listener);
                this.listenersCache.put(toc, listener);
            }
            ++i;
        }
        return children;
    }

    public Object getParent(Object element) {
        return this.workbenchContentProvider.getParent(element);
    }

    public boolean hasChildren(Object element) {
        return this.workbenchContentProvider.hasChildren(element);
    }

    public Object[] getElements(Object inputElement) {
        return this.workbenchContentProvider.getElements(inputElement);
    }

    public void dispose() {
        Object[] tocs = this.listenersCache.keySet().toArray();
        int i = 0;
        while (i < tocs.length) {
            Toc toc = (Toc)tocs[i];
            toc.removeTocListener((TocListener)this.listenersCache.remove(toc));
            ++i;
        }
        this.workbenchContentProvider.dispose();
    }
}

