/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.views;

import com.narucy.webpub.core.template.Template;
import com.narucy.webpub.core.template.TemplateManager;
import com.narucy.webpub.core.template.TemplateParser;
import com.narucy.webpub.ui.WebpubUIPlugin;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;

public class TemplateManagerViewer
extends TableTreeViewer {
    public static final String NAME = "name";
    public static final String DEFINED_LOCATION = "definedLocation";
    public static final String DESCRIPTION = "description";
    static final HashMap columnNames = new HashMap(3);
    static final String[] defaultColumn = new String[]{"name", "definedLocation", "description"};

    static {
        columnNames.put(NAME, "Name");
        columnNames.put(DEFINED_LOCATION, "Defined Location");
        columnNames.put(DESCRIPTION, "Description");
    }

    public TemplateManagerViewer(Composite parent) {
        super(parent, 65540);
        this.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TemplateManagerViewer.this.handleDoubleClick(event);
            }
        });
        this.setContentProvider((IContentProvider)new TemplateManagerContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider());
        String[] columnProperties = (String[])defaultColumn.clone();
        this.setColumnProperties(columnProperties);
        Table table = this.getTableTree().getTable();
        int i = 0;
        while (i < columnProperties.length) {
            String key = columnProperties[i];
            TableColumn col = new TableColumn(table, 0);
            col.setText((String)columnNames.get(key));
            ++i;
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn[] columns = table.getColumns();
        int i2 = 0;
        while (i2 < columns.length) {
            columns[i2].pack();
            ++i2;
        }
    }

    void handleDoubleClick(DoubleClickEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        Object input = sel.getFirstElement();
        if (input instanceof IFile) {
            try {
                IEditorPart part = WebpubUIPlugin.getActivePage().openEditor((IFile)input);
                if (part instanceof ITextEditor) {
                    ITextEditor ed = (ITextEditor)part;
                    IDocument doc = ed.getDocumentProvider().getDocument((Object)ed.getEditorInput());
                    Template t = this.getCurrentSelectionTemplate();
                    int matchLine = TemplateManagerViewer.beginTmplLineNumber(doc, t.getName());
                    ed.getSelectionProvider().setSelection((ISelection)new TextSelection(doc.getLineOffset(matchLine), 0));
                }
            }
            catch (PartInitException e) {
                WebpubUIPlugin.handleException((Exception)((Object)e));
            }
            catch (BadLocationException e) {
                WebpubUIPlugin.handleException((Exception)((Object)e));
            }
        }
        this.getCurrentSelectionTemplate();
    }

    Template getCurrentSelectionTemplate() {
        Object data;
        TableTree tableTree = this.getTableTree();
        TableTreeItem item = tableTree.getSelection()[0];
        Item itm = this.getParentItem((Item)item);
        if (itm != null && (data = itm.getData()) instanceof Template) {
            return (Template)data;
        }
        return null;
    }

    static int beginTmplLineNumber(IDocument doc, String tmplName) throws BadLocationException {
        int i = 0;
        int lineCount = doc.getNumberOfLines();
        while (i < lineCount) {
            IRegion region = doc.getLineInformation(i);
            String line = doc.get(region.getOffset(), region.getLength());
            if (tmplName.equals(TemplateParser.matchBeginTmplateLine((String)line))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static class TemplateManagerContentProvider
    implements ITreeContentProvider {
        TemplateManager manager;

        TemplateManagerContentProvider() {
        }

        public void dispose() {
            this.manager = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Template) {
                Template tmpl = (Template)parentElement;
                return this.manager.getTemplateDefinedFiles(tmpl.getName());
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                return this.manager.getTemplatesFromCache(file);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Template) {
                Template tmpl = (Template)element;
                return this.manager.getTemplateDefinedFiles(tmpl.getName()).length > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof TemplateManager) {
                this.manager = (TemplateManager)inputElement;
                return this.manager.getGlobalTemplates();
            }
            return new Object[0];
        }
    }

    class TemplateLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TemplateLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int colIndex) {
            String text = "";
            if (element instanceof Template) {
                Template tmpl = (Template)element;
                if (colIndex == 0) {
                    text = tmpl.getName();
                }
                if (colIndex == 2) {
                    text = "(Length:" + tmpl.getJoinedLines().length() + ")";
                }
            } else if (element instanceof IFile && colIndex == 1) {
                IFile f = (IFile)element;
                String path = f.getFullPath().toString();
                text = path.substring(path.indexOf(47, 1) + 1);
            }
            return text;
        }

        public boolean isLabelProperty(Object element, String property) {
            Object[] columnProperties = TemplateManagerViewer.this.getColumnProperties();
            int i = 0;
            while (i < columnProperties.length) {
                if (columnProperties[i].equals(property)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public void dispose() {
        }

        void p(Object o) {
            System.out.println(((Object)((Object)this)).getClass() + ":" + o);
        }
    }
}

