/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.views;

import com.narucy.webpub.core.TextReader;
import com.narucy.webpub.core.publish.PublisherBuilder;
import com.narucy.webpub.ui.WebpubUIPlugin;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class PublishConsoleView
extends ViewPart {
    static final String ID_DEFINICATION_FONT = "com.narucy.webpub.ui.PublishConsoleFont";
    String originalTitle;
    DateFormat dateFormat = DateFormat.getDateTimeInstance();
    long lastModified;
    Text console;
    IResourceChangeListener resourceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            Display disp = PublishConsoleView.this.getSite().getShell().getDisplay();
            disp.syncExec(new Runnable(this, disp){
                final /* synthetic */ 1 this$1;
                private final /* synthetic */ Display val$disp;
                {
                    this.this$1 = var1_1;
                    this.val$disp = display;
                }

                public void run() {
                    if (!this.val$disp.isDisposed()) {
                        1.access$0(this.this$1).reload(false);
                    }
                }
            });
        }

        static /* synthetic */ PublishConsoleView access$0(1 var0) {
            return var0.PublishConsoleView.this;
        }
    };
    IPropertyChangeListener fontChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals(PublishConsoleView.ID_DEFINICATION_FONT)) {
                PublishConsoleView.this.revalidateFont();
            }
        }
    };
    IPropertyChangeListener prefListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("publish_console_charset")) {
                PublishConsoleView.this.reload(true);
            }
        }
    };

    public void createPartControl(Composite parent) {
        this.console = new Text(parent, 778);
        this.revalidateFont();
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler("copy", (IAction)new Action(){

            public void run() {
                if (PublishConsoleView.this.console.isFocusControl()) {
                    PublishConsoleView.this.console.copy();
                }
            }
        });
        this.originalTitle = this.getTitle();
        this.reload(true);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener);
        JFaceResources.getFontRegistry().addListener(this.fontChangeListener);
        WebpubUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.prefListener);
    }

    void revalidateFont() {
        this.console.setFont(JFaceResources.getFontRegistry().get(ID_DEFINICATION_FONT));
    }

    public void setFocus() {
    }

    void reload(boolean forceReload) {
        File tmpFile = PublisherBuilder.UNPARSED_LINES_TEMPORARY_FILE;
        String title = this.originalTitle;
        if (tmpFile.exists()) {
            long lm = tmpFile.lastModified();
            if (this.lastModified != lm || forceReload) {
                this.lastModified = lm;
                try {
                    String charset = WebpubUIPlugin.getDefault().getPreferenceStore().getString("publish_console_charset");
                    this.console.setText(new TextReader(tmpFile.toURL(), charset).joinedLines());
                }
                catch (FileNotFoundException e) {
                    WebpubUIPlugin.handleException(e);
                }
                catch (IOException e) {
                    WebpubUIPlugin.handleException(e);
                }
                String dateStr = this.dateFormat.format(new Date(this.lastModified));
                title = String.valueOf(title) + " [" + dateStr + "]";
            }
        } else {
            this.console.setText("A publish console is not an available.");
        }
        this.setTitle(title);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
        WebpubUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.prefListener);
        JFaceResources.getFontRegistry().removeListener(this.fontChangeListener);
    }
}

