/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.views;

import com.narucy.webpub.core.preset.Preset;
import com.narucy.webpub.core.toc.Toc;
import com.narucy.webpub.core.toc.Topic;
import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.views.TocContentProvider;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.xml.sax.SAXException;

public class PresetViewer
extends TableTreeViewer {
    static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    public static final String KEY_LABEL = "label";
    public static final String KEY_HREF = "href";
    public static final String KEY_INITIAL_HT = "initalHt";
    static final HashMap columnNames = new HashMap(3);
    HashMap selectedInitialHtdocs = null;
    ArrayList initialHtdocs = new ArrayList();
    Preset currentPreset = null;
    Toc currentToc = null;

    static {
        columnNames.put(KEY_LABEL, "Label");
        columnNames.put(KEY_HREF, "Href");
        columnNames.put(KEY_INITIAL_HT, "Initial HTML");
    }

    static String getFileName(URL url) {
        String line = url.toString();
        int index = line.lastIndexOf(47);
        return index != -1 ? line.substring(index + 1) : "(foo)";
    }

    public PresetViewer(Composite composite) {
        this(composite, new String[]{KEY_LABEL, KEY_HREF});
    }

    public PresetViewer(Composite composite, String[] columnProp) {
        super(composite, 68356);
        this.setColumnProperties(columnProp);
        if (this.isContainHeaderProperty(KEY_INITIAL_HT)) {
            this.initialHtdocs = new ArrayList();
            this.selectedInitialHtdocs = new HashMap();
        }
        TableTree tableTree = this.getTableTree();
        Table table = tableTree.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        int i = 0;
        while (i < columnProp.length) {
            String key = columnProp[i];
            TableColumn col = new TableColumn(table, 0);
            col.setText((String)columnNames.get(key));
            ++i;
        }
        this.setContentProvider((IContentProvider)new TocContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new TocLabelProvider());
        this.setCellModifier(new TocCellModifier());
    }

    boolean isContainHeaderProperty(String mode) {
        Object[] columnProperties = this.getColumnProperties();
        int i = 0;
        while (i < columnProperties.length) {
            if (columnProperties[i].equals(mode)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setColumnProperties(String[] columnProps) {
        PresetViewer.assertHeaderProperties(columnProps);
        super.setColumnProperties((String[])columnProps.clone());
    }

    static void assertHeaderProperties(String[] props) {
        Set keys = columnNames.keySet();
        int i = 0;
        while (i < props.length) {
            if (!keys.contains(props[i])) {
                throw new IllegalArgumentException("Illegal header property key:" + props[i]);
            }
            ++i;
        }
    }

    public void setPreset(Preset preset) {
        this.currentPreset = preset;
        try {
            this.currentToc = preset.createToc();
            if (this.isContainHeaderProperty(KEY_INITIAL_HT)) {
                this.initInitialHtList(preset);
            }
        }
        catch (IOException e) {
            WebpubUIPlugin.handleException(e);
        }
        catch (SAXException e) {
            WebpubUIPlugin.handleException(e);
        }
        catch (CoreException e) {
            WebpubUIPlugin.handleException((Exception)((Object)e));
        }
        if (this.currentToc == null) {
            return;
        }
        Table table = this.getTableTree().getTable();
        Object[] columnProperties = this.getColumnProperties();
        CellEditor[] editors = new CellEditor[columnProperties.length];
        int i = 0;
        while (i < columnProperties.length) {
            String key = (String)columnProperties[i];
            if (key.equals(KEY_LABEL) || key.equals(KEY_HREF)) {
                editors[i] = new TextCellEditor((Composite)table);
            } else if (key.equals(KEY_INITIAL_HT)) {
                URL[] initalURLs = this.initialHtdocs.toArray(new URL[this.initialHtdocs.size()]);
                String[] initalURLNames = new String[initalURLs.length];
                int j = 0;
                while (j < initalURLs.length) {
                    initalURLNames[j] = PresetViewer.getFileName(initalURLs[j]);
                    ++j;
                }
                editors[i] = new ComboBoxCellEditor((Composite)table, initalURLNames);
            }
            ++i;
        }
        this.setCellEditors(editors);
        this.setInput(this.currentToc);
        this.expandToLevel(-1);
        TableColumn[] columns = table.getColumns();
        int i2 = 0;
        while (i2 < columns.length) {
            columns[i2].pack();
            ++i2;
        }
    }

    void initInitialHtList(Preset preset) throws IOException, CoreException {
        this.initialHtdocs.clear();
        this.initialHtdocs.addAll(Arrays.asList(preset.getHtSelectionURLs()));
        URL defaultInitalURL = preset.getDefaultSelectionURL();
        if (defaultInitalURL == null) {
            defaultInitalURL = (URL)this.initialHtdocs.get(0);
        }
        Topic[] topics = this.currentToc.getAllTopics();
        this.selectedInitialHtdocs.clear();
        int i = 0;
        while (i < topics.length) {
            if (topics[i].getHref() != null) {
                Topic t;
                String item;
                URL url = null;
                if (topics[i] instanceof Topic && (item = (t = topics[i]).getAttribute("selected")) != null) {
                    URL base = preset.getBaseDirectory();
                    int index = this.initialHtdocs.indexOf(new URL(base, item));
                    if (index == -1) {
                        throw new IllegalArgumentException("Invalid attribute found as inital toc: selected=\"" + item + "\"");
                    }
                    url = (URL)this.initialHtdocs.get(index);
                }
                if (url == null) {
                    url = defaultInitalURL;
                }
                this.selectedInitialHtdocs.put(topics[i], url);
            }
            ++i;
        }
    }

    void showError(String message, int severity) {
        Status status = new Status(severity, "com.narucy.webpub", 0, message, null);
        ErrorDialog.openError((Shell)this.getControl().getShell(), null, null, (IStatus)status);
    }

    public Toc getToc() {
        return this.currentToc;
    }

    public URL getInitialURL(Topic topic) {
        return (URL)this.selectedInitialHtdocs.get(topic);
    }

    class TocCellModifier
    implements ICellModifier {
        TocCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            if (!(element instanceof Topic)) {
                return false;
            }
            Topic topic = (Topic)element;
            if (property.equals(PresetViewer.KEY_INITIAL_HT)) {
                return topic.getHref() != null;
            }
            return true;
        }

        public Object getValue(Object element, String property) {
            if (element instanceof Topic) {
                Topic topic = (Topic)element;
                if (property.equals(PresetViewer.KEY_LABEL)) {
                    return topic.getLabel();
                }
                if (property.equals(PresetViewer.KEY_HREF)) {
                    String href = topic.getHref();
                    return href != null ? href : "";
                }
                if (property.equals(PresetViewer.KEY_INITIAL_HT)) {
                    URL f = PresetViewer.this.getInitialURL(topic);
                    int index = PresetViewer.this.initialHtdocs.indexOf(f);
                    return new Integer(index);
                }
            }
            return null;
        }

        public void modify(Object elem, String property, Object value) {
            Object obj;
            if (elem instanceof TableTreeItem && (obj = ((TableTreeItem)elem).getData()) instanceof Topic) {
                ArrayList<String> modifyProperties = new ArrayList<String>(3);
                Topic topic = (Topic)obj;
                if (property.equals(PresetViewer.KEY_LABEL)) {
                    topic.setLabel((String)value);
                    modifyProperties.add(PresetViewer.KEY_LABEL);
                } else if (property.equals(PresetViewer.KEY_HREF)) {
                    String p = (String)value;
                    if (p.length() <= 0) {
                        topic.setHref(null);
                        PresetViewer.this.selectedInitialHtdocs.remove(topic);
                        modifyProperties.add(PresetViewer.KEY_HREF);
                        modifyProperties.add(PresetViewer.KEY_INITIAL_HT);
                    } else {
                        topic.setHref(p);
                        modifyProperties.add(PresetViewer.KEY_HREF);
                    }
                } else if (property.equals(PresetViewer.KEY_INITIAL_HT)) {
                    int index = (Integer)value;
                    PresetViewer.this.selectedInitialHtdocs.put(topic, PresetViewer.this.initialHtdocs.get(index));
                    modifyProperties.add(PresetViewer.KEY_INITIAL_HT);
                }
                PresetViewer.this.update(topic, modifyProperties.toArray(new String[modifyProperties.size()]));
            }
        }
    }

    class TocLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TocLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object elem, int columnIndex) {
            if (elem instanceof Topic) {
                Topic topic = (Topic)elem;
                switch (columnIndex) {
                    case 0: {
                        return topic.getLabel();
                    }
                    case 1: {
                        String href = topic.getHref();
                        return href != null ? href : "(none)";
                    }
                    case 2: {
                        URL url = PresetViewer.this.getInitialURL(topic);
                        return url != null && topic.getHref() != null ? PresetViewer.getFileName(url) : "(none)";
                    }
                }
            }
            return null;
        }

        public boolean isLabelProperty(Object element, String property) {
            Object[] columnProperties = PresetViewer.this.getColumnProperties();
            int i = 0;
            while (i < columnProperties.length) {
                if (columnProperties[i].equals(property)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

