/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.views;

import com.narucy.webpub.ui.views.HTPreView;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

class HTPreviewSelectionProvider
implements ISelectionProvider {
    final HTPreView preview;
    ArrayList listenerList = new ArrayList();
    ISelection selection = null;

    public HTPreviewSelectionProvider(HTPreView preview) {
        this.preview = preview;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listenerList.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listenerList.remove(listener);
    }

    public void setSelection(ISelection sel) {
        Object o;
        if (sel instanceof IStructuredSelection && (o = ((IStructuredSelection)sel).getFirstElement()) instanceof URL) {
            URL url = (URL)o;
            String path = new File(url.getFile()).toString();
            Object[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(path));
            if (files.length > 0) {
                sel = new StructuredSelection(files);
            }
        }
        if (sel != this.selection && sel != null ? !sel.equals(this.selection) : !this.selection.equals(sel)) {
            this.selection = sel;
            this.fireSelectionChanged();
        }
    }

    protected void fireSelectionChanged() {
        Object[] listeners = this.listenerList.toArray();
        int i = 0;
        while (i < listeners.length) {
            ((ISelectionListener)listeners[i]).selectionChanged((IWorkbenchPart)this.preview, this.selection);
            ++i;
        }
    }
}

