/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.views;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.publish.SourceFileSeeker;
import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.actions.OpenEditorFromURLAction;
import com.narucy.webpub.ui.actions.RepublishAction;
import com.narucy.webpub.ui.views.AbstractWebBrowser;
import com.narucy.webpub.ui.views.HTPreviewLinkWithEditorManager;
import com.narucy.webpub.ui.views.HTPreviewSelectionProvider;
import com.narucy.webpub.ui.views.IEWebBrowser;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class HTPreView
extends ViewPart {
    static final String KEY_URL_HISTORY = "url_history";
    IPreferenceStore preferenceStore;
    AbstractWebBrowser webBrowser;
    Label notAvailableLabel;
    Control browserControl;
    boolean available = true;
    Combo urlInput;
    Action republishAction = null;
    OpenEditorFromURLAction openEditorAction = null;
    HTPreviewLinkWithEditorManager linkWithEditorMgr;
    String originalTitle;
    String loadingTitle;
    int maxItemCount = 10;
    String[] initialUrls = null;
    IResourceChangeListener resourceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            try {
                boolean[] needReload = new boolean[1];
                delta.accept(new IResourceDeltaVisitor(this, needReload){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ boolean[] val$needReload;
                    {
                        this.this$1 = var1_1;
                        this.val$needReload = blArray;
                    }

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if (this.this$1.isRefresh(delta.getResource())) {
                            this.val$needReload[0] = true;
                        }
                        return true;
                    }
                });
                if (needReload[0]) {
                    this.runReloadProc();
                }
            }
            catch (CoreException e) {
                WebpubUIPlugin.handleException((Exception)((Object)e));
            }
        }

        boolean isRefresh(IResource r) throws CoreException {
            IFile from = HTPreView.this.getCurrentPublishFrom();
            if (r instanceof IFile && from != null) {
                WebProject wp = (WebProject)from.getProject().getNature("com.narucy.webpub.core.publishNature");
                if (wp == null) {
                    return from.getProject().equals((Object)r.getProject());
                }
                IContainer pubFolder = wp.getFolder("publish_folder");
                IContainer c = r.getParent();
                while (!(c instanceof IWorkspaceRoot)) {
                    if (c.equals((Object)pubFolder)) {
                        return true;
                    }
                    c = c.getParent();
                }
            }
            return false;
        }

        void runReloadProc() {
            HTPreView.this.asyncExec(new Runnable(this){
                final /* synthetic */ 1 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void run() {
                    if (1.access$0(this.this$1).isAvailable()) {
                        1.access$0(this.this$1).webBrowser.reload();
                    }
                }
            });
        }

        static /* synthetic */ HTPreView access$0(1 var0) {
            return var0.HTPreView.this;
        }
    };

    public IFile getCurrentPublishFrom() {
        IFile from = null;
        try {
            URL url = this.webBrowser.getCurrentURL();
            if (url != null) {
                from = new SourceFileSeeker(url).getPublishFrom();
            }
        }
        catch (CoreException e) {
            WebpubUIPlugin.handleException((Exception)((Object)e));
        }
        return from;
    }

    void p(Object o) {
        System.out.println(((Object)((Object)this)).getClass() + ":" + o);
    }

    void asyncExec(Runnable proc) {
        Display disp;
        Shell sh;
        IWorkbenchPartSite site = this.getSite();
        if (site != null && (sh = site.getShell()) != null && !sh.isDisposed() && (disp = sh.getDisplay()) != null) {
            disp.asyncExec(proc);
            return;
        }
        throw new RuntimeException("Ran not invoke a runnable item:" + proc);
    }

    public IMenuManager getMenuManager() {
        return this.getViewSite().getActionBars().getMenuManager();
    }

    public void createPartControl(Composite parent) {
        this.originalTitle = this.getTitle();
        this.loadingTitle = String.valueOf(this.originalTitle) + " [loading...]";
        this.preferenceStore = WebpubUIPlugin.getDefault().getPreferenceStore();
        this.urlInput = new Combo(parent, 2052);
        if (this.initialUrls != null) {
            this.urlInput.setItems(this.initialUrls);
        }
        if (System.getProperty("os.name").indexOf("Windows") == -1) {
            throw new RuntimeException("Other Win32 platform is not supported");
        }
        this.webBrowser = new IEWebBrowser();
        this.notAvailableLabel = new Label(parent, 0);
        this.notAvailableLabel.setText("A preview is not available.");
        this.browserControl = this.webBrowser.createControl(parent);
        parent.setLayout(new Layout(){

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                return new Point(wHint, hHint);
            }

            protected void layout(Composite composite, boolean flushCache) {
                Rectangle area = composite.getClientArea();
                Point inputSize = HTPreView.this.urlInput.computeSize(-1, -1);
                HTPreView.this.urlInput.setLocation(0, 0);
                HTPreView.this.urlInput.setSize(area.width, inputSize.y);
                area.y = inputSize.y + 2;
                area.height -= inputSize.y;
                Control enable = HTPreView.this.available ? HTPreView.this.browserControl : HTPreView.this.notAvailableLabel;
                Label disable = HTPreView.this.available ? HTPreView.this.notAvailableLabel : HTPreView.this.browserControl;
                disable.setEnabled(false);
                disable.setSize(0, 0);
                enable.setEnabled(true);
                enable.setBounds(area);
            }
        });
        IMenuManager menuMgr = this.getMenuManager();
        menuMgr.add((IAction)new Action("&Deselect Target"){

            public void run() {
                HTPreView.this.browsePage(null);
            }
        });
        this.linkWithEditorMgr = new HTPreviewLinkWithEditorManager(this);
        IActionBars bars = this.getViewSite().getActionBars();
        this.republishAction = new Action(){

            public void run() {
                IFile republishTarget = HTPreView.this.getCurrentPublishFrom();
                if (republishTarget != null) {
                    RepublishAction act = new RepublishAction();
                    act.init(HTPreView.this.getSite().getWorkbenchWindow());
                    act.selectionChanged((IAction)this, (ISelection)new StructuredSelection((Object)republishTarget));
                    act.run((IAction)this);
                }
            }
        };
        this.republishAction.setToolTipText("Publish");
        this.republishAction.setImageDescriptor(WebpubUIPlugin.getDefault().getImageDescriptor("ctool16/republish.gif"));
        IToolBarManager toolBar = bars.getToolBarManager();
        toolBar.add((IAction)this.republishAction);
        this.openEditorAction = new OpenEditorFromURLAction();
        toolBar.add((IAction)this.openEditorAction);
        toolBar.add((IAction)this.linkWithEditorMgr.getLinkWithEditorAction());
        bars.setGlobalActionHandler("cut", (IAction)new Action(){

            public void run() {
                if (HTPreView.this.urlInput.isFocusControl()) {
                    HTPreView.this.urlInput.cut();
                }
            }
        });
        bars.setGlobalActionHandler("copy", (IAction)new Action(){

            public void run() {
                if (HTPreView.this.urlInput.isFocusControl()) {
                    HTPreView.this.urlInput.copy();
                }
            }
        });
        bars.setGlobalActionHandler("paste", (IAction)new Action(){

            public void run() {
                if (HTPreView.this.urlInput.isFocusControl()) {
                    HTPreView.this.urlInput.paste();
                }
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)new HTPreviewSelectionProvider(this));
        this.urlInput.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' || e.character == '\n') {
                    HTPreView.this.enterUrl();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.urlInput.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HTPreView.this.browsePage(HTPreView.createUrl(HTPreView.this.urlInput.getText()));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener);
        this.webBrowser.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("url_change_started")) {
                    if (event.getNewValue() != null) {
                        HTPreView.this.setTitle(HTPreView.this.loadingTitle);
                    }
                } else if (event.getProperty().equals("url_change_complted")) {
                    URL url = (URL)event.getNewValue();
                    HTPreView.this.urlInput.setText(url.toString());
                    String title = HTPreView.this.originalTitle;
                    String pageTitle = HTPreView.this.webBrowser.getTitle();
                    if (pageTitle != null) {
                        title = String.valueOf(title) + " - " + pageTitle;
                    }
                    HTPreView.this.setTitle(title);
                    HTPreView.this.refreshActionsState();
                    HTPreView.this.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)url));
                }
            }
        });
        this.browsePage(null);
        this.urlInput.forceFocus();
        this.refreshActionsState();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        String urlListStr;
        super.init(site, memento);
        if (memento != null && (urlListStr = memento.getString(KEY_URL_HISTORY)) != null) {
            this.initialUrls = urlListStr.split("\\s+");
        }
    }

    void enterUrl() {
        String text = this.urlInput.getText();
        URL url = HTPreView.createUrl(text);
        if (url != null) {
            String urlText = url.toString();
            if (!text.equals(urlText)) {
                this.urlInput.setText(urlText);
            }
            if (!this.isContainURLHistory(url)) {
                this.urlInput.add(urlText, 0);
            }
            this.urlInput.setText(urlText);
            if (this.urlInput.getItemCount() > this.maxItemCount) {
                this.urlInput.remove(this.urlInput.getItemCount() - 1);
            }
            this.browsePage(url);
        } else {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)("Specify URL is invalid: " + text), null);
        }
    }

    static URL createUrl(String text) {
        try {
            return new URL(text);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return new URL("http://" + text);
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
    }

    void refreshActionsState() {
        URL url = this.webBrowser.getCurrentURL();
        if (url != null) {
            IFile pubFrom = this.getCurrentPublishFrom();
            this.republishAction.setEnabled(pubFrom != null && url.getProtocol().equals("file"));
            this.openEditorAction.setOpenFile(pubFrom);
        }
    }

    boolean isContainURLHistory(URL url) {
        this.urlInput.getItems();
        int i = 0;
        while (i < this.urlInput.getItemCount()) {
            if (this.urlInput.getItem(i).equals(url.toString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isPreviewble(IFile f) {
        String[] previewExts = StringConverter.asArray((String)this.preferenceStore.getString("ht_preview_extensions"));
        String ext = f.getFileExtension();
        int i = 0;
        while (i < previewExts.length) {
            if (ext != null && ext.equals(previewExts[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void browsePage(URL url) {
        this.available = url != null;
        this.browserControl.getParent().layout();
        this.webBrowser.browsePage(url);
        String urlStr = this.available ? url.toString() : "";
        this.urlInput.setText(urlStr);
        if (!this.available) {
            this.setTitle(this.originalTitle);
        }
    }

    public boolean isAvailable() {
        return this.browserControl != null && !this.browserControl.isDisposed() && this.available;
    }

    public void setFocus() {
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
        this.linkWithEditorMgr.dispose();
        this.browserControl.dispose();
        super.dispose();
    }

    public AbstractWebBrowser getWebBrowser() {
        return this.webBrowser;
    }

    public void saveState(IMemento memento) {
        String[] urls = this.urlInput.getItems();
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < urls.length) {
            buff.append(urls[i]);
            if (i != urls.length - 1) {
                buff.append(' ');
            }
            ++i;
        }
        memento.putString(KEY_URL_HISTORY, buff.toString());
    }
}

