/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.views;

import com.narucy.webpub.core.template.TemplateManager;
import com.narucy.webpub.core.template.TemplateManagerListener;
import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.views.TemplateManagerViewer;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.navigator.IResourceNavigator;

public class GlobalTemplateView
extends ViewPart {
    String originalTitle;
    IProject currentProject = null;
    TemplateManagerViewer viewer;
    ISelectionService selService;
    HashMap listenersRef = new HashMap();
    Action reloadAction;
    ISelectionListener selListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            GlobalTemplateView.this.workbenchSelectionChanged(selection);
        }
    };
    TemplateManagerListener managerListener = new TemplateManagerListener(){
        Runnable proc = new Runnable(this){
            final /* synthetic */ 2 this$1;
            {
                this.this$1 = var1_1;
            }

            public void run() {
                2.access$0(this.this$1).packColumns();
            }
        };

        public void templateModified(IProject proj) {
            GlobalTemplateView.this.getSite().getShell().getDisplay().syncExec(this.proc);
        }

        static /* synthetic */ GlobalTemplateView access$0(2 var0) {
            return var0.GlobalTemplateView.this;
        }
    };
    static /* synthetic */ Class class$0;

    public void createPartControl(Composite parent) {
        IResourceNavigator navigatorView;
        this.originalTitle = this.getTitle();
        this.viewer = new TemplateManagerViewer(parent);
        this.reloadAction = new Action("Reload", WebpubUIPlugin.getDefault().getImageDescriptor("ctool16/reload.gif")){

            public void run() {
                try {
                    ((TemplateManager)GlobalTemplateView.this.viewer.getInput()).researchAll((IProgressMonitor)new NullProgressMonitor());
                    GlobalTemplateView.this.packColumns();
                }
                catch (CoreException e) {
                    WebpubUIPlugin.handleException((Exception)((Object)e));
                }
            }
        };
        IViewSite site = this.getViewSite();
        site.getActionBars().getToolBarManager().add((IAction)this.reloadAction);
        this.selService = site.getWorkbenchWindow().getSelectionService();
        this.selService.addSelectionListener(this.selListener);
        this.workbenchSelectionChanged(this.selService.getSelection());
        if (this.currentProject == null && (navigatorView = (IResourceNavigator)site.getPage().findView("org.eclipse.ui.views.ResourceNavigator")) != null) {
            this.workbenchSelectionChanged(navigatorView.getViewSite().getSelectionProvider().getSelection());
        }
    }

    void packColumns() {
        if (this.currentProject != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.refresh();
            TableColumn[] cols = this.viewer.getTableTree().getTable().getColumns();
            int i = 0;
            while (i < cols.length) {
                cols[i].pack();
                ++i;
            }
        }
    }

    public void workbenchSelectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object[] items = ((IStructuredSelection)selection).toArray();
            int i = 0;
            while (i < items.length) {
                IResource res = GlobalTemplateView.getResource(items[i]);
                if (res != null) {
                    try {
                        this.changeShowProject(res.getProject());
                    }
                    catch (CoreException e) {
                        WebpubUIPlugin.handleException((Exception)((Object)e));
                    }
                }
                ++i;
            }
        }
    }

    static IResource getResource(Object o) {
        if (o instanceof IResource) {
            return (IResource)o;
        }
        if (o instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)o;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IResource)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    void changeShowProject(IProject proj) throws CoreException {
        if (proj == this.currentProject) {
            return;
        }
        TemplateManager mgr = (TemplateManager)this.viewer.getInput();
        if (mgr != null) {
            mgr.removeListener(this.managerListener);
        }
        this.currentProject = proj;
        if (proj != null) {
            mgr = TemplateManager.getManagerInstance((IProject)proj);
            if (mgr != null) {
                mgr.addListener(this.managerListener);
                try {
                    mgr.researchAll((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    WebpubUIPlugin.handleException((Exception)((Object)e));
                }
                this.viewer.setInput(mgr);
                this.viewer.refresh(true);
            }
            this.reloadAction.setEnabled(true);
            this.setTitle(String.valueOf(this.originalTitle) + " - " + proj.getName());
        } else {
            this.viewer.setInput(null);
            this.reloadAction.setEnabled(false);
            this.setTitle(this.originalTitle);
        }
        this.packColumns();
    }

    public void setFocus() {
    }

    void p(Object o) {
        System.out.println(((Object)((Object)this)).getClass() + ":" + o);
    }

    public void dispose() {
        this.selService.removeSelectionListener(this.selListener);
        TemplateManager manager = (TemplateManager)this.viewer.getInput();
        if (this.currentProject != null) {
            manager.removeListener(this.managerListener);
        }
        super.dispose();
    }
}

