/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.properties;

import com.narucy.webpub.core.StatusChangeListener;
import com.narucy.webpub.core.WebProject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class WebProjectStructureBlock {
    StatusChangeListener statusListener;
    WebProject webProj;
    Composite base;
    HashMap widgets = null;
    WebProject createdDescription = null;
    ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            WebProjectStructureBlock.this.checkValues();
        }
    };
    SelectionListener browseButtonListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            Object[] ks = WebProjectStructureBlock.this.widgets.keySet().toArray();
            int i = 0;
            while (i < ks.length) {
                String k = (String)ks[i];
                if (WebProjectStructureBlock.this.getButton(k).equals(e.widget)) {
                    WebProjectStructureBlock.this.callContainerSelectionDialog(k);
                }
                ++i;
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    public WebProjectStructureBlock(StatusChangeListener statusListener) {
        this.statusListener = statusListener;
    }

    public Composite createControl(Composite parent, IProject project) throws CoreException {
        this.webProj = project != null ? (WebProject)project.getNature("com.narucy.webpub.core.publishNature") : null;
        this.base = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 9;
        this.base.setLayout((Layout)layout);
        this.createText("htsources_folder", "HTML source folder:");
        this.createText("scripts_folder", "&Script directory:");
        this.createText("publish_folder", "&Publishing folder:");
        if (this.webProj != null) {
            this.setFolderData(this.webProj.getString("htsources_folder"), this.webProj.getString("scripts_folder"), this.webProj.getString("publish_folder"));
        }
        return this.base;
    }

    public void forceFocus() {
        this.getTextControl("htsources_folder").forceFocus();
    }

    void setPath(String key, IPath fullPath) {
        Text text = this.getTextControl(key);
        if (this.webProj.getProject().getFullPath().isPrefixOf(fullPath)) {
            text.setText(fullPath.removeFirstSegments(1).toString());
        } else {
            text.setText(fullPath.toString());
        }
    }

    void callContainerSelectionDialog(String key) {
        IProject project = this.webProj.getProject();
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.base.getShell(), (IContainer)project, true, "Select container");
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            this.setPath(key, (IPath)result[0]);
        }
    }

    void p(Object o) {
        System.out.println(this.getClass() + ":" + o);
    }

    void createText(String key, String textData) {
        new Label(this.base, 0).setText(textData);
        Composite inputBase = new Composite(this.base, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        inputBase.setLayout((Layout)gl);
        inputBase.setLayoutData((Object)new GridData(768));
        Text text = new Text(inputBase, 2052);
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(this.modifyListener);
        Button button = new Button(inputBase, 8);
        button.setText("Browse...");
        button.addSelectionListener(this.browseButtonListener);
        if (this.widgets == null) {
            this.widgets = new HashMap();
        }
        this.widgets.put(key, new Object[]{text, button});
    }

    public void setFolderData(String htFolderName, String scriptFolderName, String publishFolderName) {
        this.getTextControl("htsources_folder").setText(htFolderName);
        this.getTextControl("scripts_folder").setText(scriptFolderName);
        this.getTextControl("publish_folder").setText(publishFolderName);
        this.checkValues();
    }

    Text getTextControl(String key) {
        return (Text)((Object[])this.widgets.get(key))[0];
    }

    public String getText(String key) {
        return this.getTextControl(key).getText();
    }

    public Button getButton(String key) {
        return (Button)((Object[])this.widgets.get(key))[1];
    }

    void checkValues() {
        String htFolderName = this.getText("htsources_folder");
        String scriptFolderName = this.getText("scripts_folder");
        String publishFolderName = this.getText("publish_folder");
        if (publishFolderName.equals(htFolderName)) {
            this.updateMessage("Base HTML folder and publish folder must be different.", 4);
        } else if (publishFolderName.equals(scriptFolderName)) {
            this.updateMessage("Script folder and publish folder must be different.", 4);
        } else if (htFolderName.length() == 0) {
            this.updateMessage("Recommend specify base HTML folder.", 2);
        } else if (scriptFolderName.length() == 0) {
            this.updateMessage("Recommend specify script folder.", 2);
        } else if (htFolderName.charAt(0) == '/') {
            this.updateMessage("Recommends HTML source folder included to same project.", 2);
        } else if (scriptFolderName.charAt(0) == '/') {
            this.updateMessage("Recommends script folder included to same project.", 2);
        } else if (scriptFolderName.equals(htFolderName)) {
            this.updateMessage("Recommend base HTML folder and script folder specifiy different.", 2);
        } else {
            this.updateMessage(null, 0);
        }
    }

    void updateMessage(String msg, int severity) {
        Status status = new Status(severity, "com.narucy.webpub", 0, msg != null ? msg : "", null);
        this.statusListener.statusChanged((IStatus)status);
    }

    static Map getLanguages() {
        Locale[] locales = Locale.getAvailableLocales();
        HashMap<String, String> hash = new HashMap<String, String>();
        int i = 0;
        while (i < locales.length) {
            Locale locale = locales[i];
            String lang = locale.getLanguage();
            if (!hash.containsKey(lang)) {
                hash.put(lang, locale.getDisplayLanguage());
            }
            ++i;
        }
        return hash;
    }

    public WebProject getCreatedDescription() {
        return this.createdDescription;
    }

    public void setEditable(boolean editable) {
        if (this.widgets != null) {
            Object[] keys = this.widgets.keySet().toArray();
            int i = 0;
            while (i < keys.length) {
                String k = (String)keys[i];
                this.getTextControl(k).setEnabled(editable);
                this.getButton(k).setEnabled(editable);
                ++i;
            }
        }
    }

    public Composite getControl() {
        return this.base;
    }
}

