/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.editors.toc;

import com.narucy.webpub.core.toc.Toc;
import com.narucy.webpub.core.toc.TocEvent;
import com.narucy.webpub.core.toc.TocListener;
import com.narucy.webpub.core.toc.Topic;
import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.editors.toc.TocController;
import com.narucy.webpub.ui.views.TocContentProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.dialogs.ResourceSorter;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class TocEditBlock {
    Cursor cursor;
    TreeViewer pubFolderTree;
    TreeViewer tocTree;
    Button addButton;
    Button removeButton;
    Button addAllButton;
    Button removeAllButton;
    Button upButton;
    Button leftButton;
    Button rightButton;
    Button downButton;
    Button createEmptyButton;
    Composite base;
    Composite buttonBase;
    Toc toc = null;
    IContainer publishFolder;
    TocController controller;
    TocListener tocListener = new TocListener(){

        public void topicChanged(TocEvent[] events) {
            TocEditBlock.this.base.getDisplay().asyncExec(new Runnable(this){
                final /* synthetic */ 1 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void run() {
                    if (!1.access$0(this.this$1).base.isDisposed()) {
                        1.access$0(this.this$1).tocTree.refresh();
                        1.access$0(this.this$1).refreshButtonState();
                    }
                }
            });
        }

        static /* synthetic */ TocEditBlock access$0(1 var0) {
            return var0.TocEditBlock.this;
        }
    };
    SelectionListener buttonListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            Object[] expanded = TocEditBlock.this.tocTree.getExpandedElements();
            if (e.widget == TocEditBlock.this.addButton) {
                TocEditBlock.this.handleAddButton();
            }
            if (e.widget == TocEditBlock.this.removeButton) {
                TocEditBlock.this.handleRemoveButton();
            }
            if (e.widget == TocEditBlock.this.addAllButton) {
                TocEditBlock.this.handleAddAllButton();
            }
            if (e.widget == TocEditBlock.this.removeAllButton) {
                TocEditBlock.this.handleRemoveAllButton();
            }
            if (e.widget == TocEditBlock.this.upButton) {
                TocEditBlock.this.handleUpButton();
            }
            if (e.widget == TocEditBlock.this.leftButton) {
                TocEditBlock.this.handleLeftButton();
            }
            if (e.widget == TocEditBlock.this.rightButton) {
                TocEditBlock.this.handleRightButton();
            }
            if (e.widget == TocEditBlock.this.downButton) {
                TocEditBlock.this.handleDownButton();
            }
            if (e.widget == TocEditBlock.this.createEmptyButton) {
                TocEditBlock.this.handleCreateEmptyButton();
            }
            TocEditBlock.this.toc.fireChanged();
            Topic[] ts = TocEditBlock.this.toc.getAllTopics();
            int i = 0;
            while (i < ts.length) {
                Topic t = ts[i];
                int j = 0;
                while (j < expanded.length) {
                    if (t.equals(expanded[j])) {
                        TocEditBlock.this.tocTree.expandToLevel((Object)t, 1);
                    }
                    ++j;
                }
                ++i;
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    public TocEditBlock(Composite parent) {
        this.base = new Composite(parent, 0);
        this.base.setLayout((Layout)new GridLayout(3, false));
        this.cursor = new Cursor((Device)this.base.getDisplay(), 9);
        new Label(this.base, 0).setText("Resources");
        new Label(this.base, 0);
        new Label(this.base, 0).setText("Sitemap");
        this.pubFolderTree = new TreeViewer(this.base);
        this.pubFolderTree.getControl().setLayoutData((Object)new GridData(1040));
        this.pubFolderTree.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.pubFolderTree.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.pubFolderTree.setSorter((ViewerSorter)new ResourceSorter(2));
        this.pubFolderTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TocEditBlock.this.refreshButtonState();
            }
        });
        this.buttonBase = new Composite(this.base, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 4;
        this.buttonBase.setLayout((Layout)gl);
        this.addButton = this.createButton(">");
        this.removeButton = this.createButton("<");
        this.addAllButton = this.createButton(">>");
        this.removeAllButton = this.createButton("<<");
        new Label(this.buttonBase, 0);
        this.upButton = this.createButton("&Up");
        this.leftButton = this.createButton("&Left");
        this.rightButton = this.createButton("&Right");
        this.downButton = this.createButton("&Down");
        new Label(this.buttonBase, 0);
        this.createEmptyButton = this.createButton("&Create Empty");
        this.tocTree = new TreeViewer(this.base);
        this.tocTree.getControl().setLayoutData((Object)new GridData(1808));
        this.tocTree.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider(){

            public String decorateText(String text, Object e) {
                String href = ((Topic)e).getHref();
                return href != null ? String.valueOf(text) + " (" + href + ")" : text;
            }
        });
        this.tocTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TocEditBlock.this.refreshButtonState();
            }
        });
        this.tocTree.setContentProvider((IContentProvider)new TocContentProvider());
        this.tocTree.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TocEditBlock.this.toc != null) {
                    TocEditBlock.this.toc.removeTocListener(TocEditBlock.this.tocListener);
                    TocEditBlock.this.cursor.dispose();
                }
            }
        });
        this.base.addMouseListener(new MouseListener(){
            int bx;

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                this.bx = e.x;
                TocEditBlock.this.base.setCursor(TocEditBlock.this.cursor);
            }

            public void mouseUp(MouseEvent e) {
                Control control = TocEditBlock.this.pubFolderTree.getControl();
                GridData gd = (GridData)control.getLayoutData();
                if (gd.widthHint == -1) {
                    gd.widthHint = control.getSize().x;
                }
                gd.widthHint += e.x - this.bx;
                TocEditBlock.this.base.layout();
                TocEditBlock.this.base.setCursor(null);
            }
        });
        this.setEnable(false);
    }

    public void setInput(IContainer pubFolder, Toc t) {
        if (this.toc == t || (t != null ? t.equals((Object)this.toc) : this.toc.equals((Object)t))) {
            return;
        }
        if (this.toc != null) {
            this.toc.removeTocListener(this.tocListener);
        }
        this.publishFolder = pubFolder;
        this.toc = t;
        if (this.publishFolder != null && this.toc != null) {
            this.pubFolderTree.setInput((Object)pubFolder);
            this.tocTree.setInput((Object)this.toc);
            this.tocTree.expandAll();
            this.controller = new TocController(pubFolder, this.toc);
            this.toc.addTocListener(this.tocListener);
            this.setEnable(true);
            this.refreshButtonState();
        } else {
            this.setEnable(false);
        }
    }

    void setEnable(boolean b) {
        TocEditBlock.notifyEnable(this.base, b);
    }

    static void notifyEnable(Composite p, boolean b) {
        Control[] children = p.getChildren();
        int i = 0;
        while (i < children.length) {
            Control control = children[i];
            control.setEnabled(b);
            if (control instanceof Composite) {
                TocEditBlock.notifyEnable((Composite)control, b);
            }
            ++i;
        }
    }

    void refreshButtonState() {
        IResource[] resources = this.getSelectedResources();
        this.addButton.setEnabled(resources.length == 0 ? false : !this.controller.isAlreadyAdded(resources));
        this.addAllButton.setEnabled(!this.controller.isAllResourcesAdded());
        Topic[] topics = this.getSelectedTopics();
        this.removeButton.setEnabled(topics.length > 0);
        this.removeAllButton.setEnabled(this.toc.hasSubtopics());
        boolean selected = topics.length > 0;
        this.createEmptyButton.setEnabled(selected);
        boolean up = selected;
        boolean left = selected;
        boolean right = selected;
        boolean down = selected;
        if (selected) {
            int i = 0;
            while (i < topics.length) {
                if (topics[i].getNextTopic(false) == null) {
                    down = false;
                }
                if (topics[i].getPrevTopic(false) == null) {
                    up = false;
                    right = false;
                }
                if (topics[i].getParent() instanceof Toc) {
                    left = false;
                }
                ++i;
            }
        }
        this.upButton.setEnabled(up);
        this.leftButton.setEnabled(left);
        this.rightButton.setEnabled(right);
        this.downButton.setEnabled(down);
    }

    Button createButton(String name) {
        Button button = new Button(this.buttonBase, 0x800000);
        button.setLayoutData((Object)new GridData(264));
        button.setText(name);
        button.addSelectionListener(this.buttonListener);
        return button;
    }

    IResource[] getSelectedResources() {
        List l = ((IStructuredSelection)this.pubFolderTree.getSelection()).toList();
        return l.toArray(new IResource[l.size()]);
    }

    Topic[] getSelectedTopics() {
        List l = ((IStructuredSelection)this.tocTree.getSelection()).toList();
        return l.toArray(new Topic[l.size()]);
    }

    protected void handleCreateEmptyButton() {
        InputDialog dialog = new InputDialog(this.base.getShell(), "New Node", "Create empty node", null, null);
        if (dialog.open() == 0) {
            this.createEmptyNode(dialog.getValue());
        }
    }

    void createEmptyNode(String name) {
        Topic[] ts = this.getSelectedTopics();
        Topic emptyNode = (ts.length > 0 ? ts[0] : this.toc).createTopic(null, name);
        this.tocTree.setSelection((ISelection)new StructuredSelection((Object)emptyNode));
    }

    protected void handleDownButton() {
        Topic[] topics = this.getSelectedTopics();
        int i = topics.length - 1;
        while (i >= 0) {
            topics[i].moveDown();
            --i;
        }
    }

    protected void handleLeftButton() {
        Topic[] topics = this.getSelectedTopics();
        int i = 0;
        while (i < topics.length) {
            topics[i].levelDown();
            ++i;
        }
    }

    protected void handleRightButton() {
        Topic[] topics = this.getSelectedTopics();
        int i = 0;
        while (i < topics.length) {
            topics[i].levelUp();
            ++i;
        }
    }

    protected void handleUpButton() {
        Topic[] topics = this.getSelectedTopics();
        int i = 0;
        while (i < topics.length) {
            topics[i].moveUp();
            ++i;
        }
    }

    protected void handleRemoveAllButton() {
        this.toc.removeSubtopics();
    }

    protected void handleRemoveButton() {
        Topic[] removeTopics = this.getSelectedTopics();
        Topic nextSelection = this.controller.findNextSelectionTopic(removeTopics);
        int i = 0;
        while (i < removeTopics.length) {
            Topic t = removeTopics[i];
            t.getParent().removeTopic(t);
            ++i;
        }
        if (nextSelection != null) {
            this.tocTree.setSelection((ISelection)new StructuredSelection((Object)nextSelection));
        }
    }

    protected void handleAddButton() {
        try {
            this.invokeInsertResourceToToc(this.getSelectedResources());
        }
        catch (CoreException e) {
            WebpubUIPlugin.handleException((Exception)((Object)e));
        }
    }

    protected void handleAddAllButton() {
        try {
            this.invokeInsertResourceToToc(this.publishFolder.members());
        }
        catch (CoreException e) {
            WebpubUIPlugin.handleException((Exception)((Object)e));
        }
    }

    void invokeInsertResourceToToc(IResource[] resources) throws CoreException {
        Topic[] topics = this.getSelectedTopics();
        ArrayList<Topic> added = new ArrayList<Topic>();
        Toc parent = topics.length > 0 ? topics[0] : this.toc;
        int i = 0;
        while (i < resources.length) {
            added.addAll(Arrays.asList(this.controller.insertResourceToToc(resources[i], (Topic)parent)));
            ++i;
        }
        this.tocTree.setSelection((ISelection)new StructuredSelection(added));
    }

    public void setBackground(Color color) {
        this.base.setBackground(color);
        this.buttonBase.setBackground(color);
        Control[] controls = this.base.getChildren();
        int i = 0;
        while (i < controls.length) {
            Control c = controls[i];
            if (c instanceof Label) {
                ((Label)c).setBackground(color);
            }
            ++i;
        }
    }

    public Composite getControl() {
        return this.base;
    }

    public TreeViewer getTocTree() {
        return this.tocTree;
    }
}

