/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.editors.html;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.swt.custom.StyleRange;

public class NonRuleBasedDamagerRepairer
implements IPresentationDamager,
IPresentationRepairer {
    IDocument document;
    TextAttribute textAttribute;

    public void setDocument(IDocument document) {
        this.document = document;
    }

    protected int endOfLineOf(int offset) throws BadLocationException {
        IRegion info = this.document.getLineInformationOfOffset(offset);
        if (offset <= info.getOffset() + info.getLength()) {
            return info.getOffset() + info.getLength();
        }
        int line = this.document.getLineOfOffset(offset);
        try {
            info = this.document.getLineInformation(line + 1);
            return info.getOffset() + info.getLength();
        }
        catch (BadLocationException badLocationException) {
            return this.document.getLength();
        }
    }

    public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent event, boolean documentPartitioningChanged) {
        if (!documentPartitioningChanged) {
            try {
                IRegion info = this.document.getLineInformationOfOffset(event.getOffset());
                int start = Math.max(partition.getOffset(), info.getOffset());
                int end = event.getOffset() + (event.getText() == null ? event.getLength() : event.getText().length());
                end = info.getOffset() <= end && end <= info.getOffset() + info.getLength() ? info.getOffset() + info.getLength() : this.endOfLineOf(end);
                end = Math.min(partition.getOffset() + partition.getLength(), end);
                return new Region(start, end - start);
            }
            catch (BadLocationException badLocationException) {}
        }
        return partition;
    }

    public TextAttribute getTextAttribute() {
        return this.textAttribute;
    }

    public void setTextAttribute(TextAttribute attribute) {
        this.textAttribute = attribute;
    }

    public void createPresentation(TextPresentation presentation, ITypedRegion region) {
        this.addRange(presentation, region.getOffset(), region.getLength(), this.textAttribute);
    }

    protected void addRange(TextPresentation presentation, int offset, int length, TextAttribute attr) {
        if (attr != null) {
            presentation.addStyleRange(new StyleRange(offset, length, attr.getForeground(), attr.getBackground(), attr.getStyle()));
        }
    }
}

