/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.editors.html;

import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.editors.ColorManager;
import com.narucy.webpub.ui.editors.html.HTContentAssistProcessor;
import com.narucy.webpub.ui.editors.html.HTDoubleClickStrategy;
import com.narucy.webpub.ui.editors.html.HTScanner;
import com.narucy.webpub.ui.editors.html.NonRuleBasedDamagerRepairer;
import com.narucy.webpub.ui.editors.html.TagScanner;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;

public class HTViewerConfiguration
extends SourceViewerConfiguration
implements IPropertyChangeListener {
    ColorManager colorManager;
    HTDoubleClickStrategy doubleClickStrategy = null;
    HTContentAssistProcessor processor = null;
    HTScanner htScanner;
    TagScanner tagScanner;
    DefaultDamagerRepairer htDr;
    DefaultDamagerRepairer tagDr;
    NonRuleBasedDamagerRepairer commentDamagerRepairer;
    NonRuleBasedDamagerRepairer erbDamagerRepairer;
    IAnnotationHover hover = new IAnnotationHover(){

        public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
            return null;
        }
    };
    ContentAssistant assistant = null;

    public HTViewerConfiguration(ColorManager colorManager) {
        this.colorManager = colorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__html_tag", "__html_comment", "__html_erb"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return this.doubleClickStrategy;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        if (this.htScanner == null) {
            this.htScanner = new HTScanner(this.colorManager);
            this.tagScanner = new TagScanner(this.colorManager);
            this.htDr = new DefaultDamagerRepairer((ITokenScanner)this.htScanner);
            this.tagDr = new DefaultDamagerRepairer((ITokenScanner)this.tagScanner);
            this.commentDamagerRepairer = this.createNonRuleBasedDamagerRepairer("ht_editor_color_comment");
            this.erbDamagerRepairer = this.createNonRuleBasedDamagerRepairer("ht_editor_color_erb");
        }
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDamager((IPresentationDamager)this.htDr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)this.htDr, "__dftl_partition_content_type");
        reconciler.setDamager((IPresentationDamager)this.tagDr, "__html_tag");
        reconciler.setRepairer((IPresentationRepairer)this.tagDr, "__html_tag");
        reconciler.setDamager((IPresentationDamager)this.commentDamagerRepairer, "__html_comment");
        reconciler.setRepairer((IPresentationRepairer)this.commentDamagerRepairer, "__html_comment");
        reconciler.setDamager((IPresentationDamager)this.erbDamagerRepairer, "__html_erb");
        reconciler.setRepairer((IPresentationRepairer)this.erbDamagerRepairer, "__html_erb");
        return reconciler;
    }

    NonRuleBasedDamagerRepairer createNonRuleBasedDamagerRepairer(String key) {
        NonRuleBasedDamagerRepairer dr = new NonRuleBasedDamagerRepairer();
        dr.setTextAttribute(new TextAttribute(this.colorManager.getColor(key)));
        return dr;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return this.hover;
    }

    protected IPreferenceStore getPreferenceStore() {
        return WebpubUIPlugin.getDefault().getPreferenceStore();
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.assistant == null) {
            IPreferenceStore store = this.getPreferenceStore();
            this.assistant = new ContentAssistant();
            this.setCodeAssistEnabled(store.getBoolean("ht_editor_content_assist"));
            this.assistant.setInformationControlCreator(new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    return new DefaultInformationControl(parent, 768, null);
                }
            });
            this.assistant.enableAutoActivation(true);
            this.assistant.setAutoActivationDelay(store.getInt("ht_editor_content_assist_delay"));
        }
        return this.assistant;
    }

    public void propertyChange(PropertyChangeEvent event) {
        IPreferenceStore store = WebpubUIPlugin.getDefault().getPreferenceStore();
        String prop = event.getProperty();
        if (this.assistant != null) {
            if (prop.equals("ht_editor_content_assist")) {
                this.setCodeAssistEnabled(store.getBoolean(prop));
            } else if (prop.equals("ht_editor_content_assist_delay")) {
                this.assistant.setAutoActivationDelay(store.getInt(prop));
            }
        }
        if (prop.equals("ht_editor_color_comment")) {
            this.commentDamagerRepairer.setTextAttribute(new TextAttribute(this.colorManager.getColor(prop)));
        } else if (prop.equals("ht_editor_color_erb")) {
            this.erbDamagerRepairer.setTextAttribute(new TextAttribute(this.colorManager.getColor(prop)));
        } else {
            this.htScanner.propertyChange(event);
            this.tagScanner.propertyChange(event);
        }
    }

    synchronized void setCodeAssistEnabled(boolean enable) {
        if (enable == (this.processor != null)) {
            return;
        }
        this.processor = enable ? new HTContentAssistProcessor(this.colorManager) : null;
        this.assistant.setContentAssistProcessor((IContentAssistProcessor)this.processor, "__dftl_partition_content_type");
        this.assistant.setContentAssistProcessor(null, "__html_comment");
        this.assistant.setContentAssistProcessor(null, "__html_erb");
        this.assistant.setContentAssistProcessor((IContentAssistProcessor)this.processor, "__html_default");
        this.assistant.setContentAssistProcessor((IContentAssistProcessor)this.processor, "__html_tag");
    }
}

