/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.editors.html;

import com.narucy.webpub.ui.HTParser;
import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.editors.ColorManager;
import com.narucy.webpub.ui.editors.html.HTContentAssistEngine;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.xml.sax.SAXException;

class HTContentAssistProcessor
implements IContentAssistProcessor {
    static final int PROPOSAL_MODE_NONE = 0;
    static final int PROPOSAL_MODE_INSERT_ELEMENT = 1;
    static final int PROPOSAL_MODE_MODIFY_ELEMENT = 2;
    static final int PROPOSAL_MODE_CLOSEING_ELEMENT = 3;
    static final int PROPOSAL_MODE_ATTRIBUTE = 4;
    static final int PROPOSAL_MODE_ATTRIBUTE_VALUE = 5;
    static HTContentAssistEngine engine = HTContentAssistEngine.getInstance();
    static char[] spaceChars = new char[]{' ', '\n', '\r', '\t'};
    char[] autoActivationChars = new char[]{'<'};
    ColorManager colorManager;

    static {
        Arrays.sort(spaceChars);
    }

    public HTContentAssistProcessor(ColorManager colorManager) {
        this.colorManager = colorManager;
        if (engine.getCurrentType() == null) {
            try {
                engine.initTypes("xhtml-strict.rng");
            }
            catch (ParserConfigurationException e) {
                WebpubUIPlugin.handleException(e);
            }
            catch (SAXException e) {
                WebpubUIPlugin.handleException(e);
            }
            catch (IOException e) {
                WebpubUIPlugin.handleException(e);
            }
        }
    }

    static int getComplationPrefixIndex(IDocument doc, int offset, char[] foundChar, char[] invalidChar) throws BadLocationException {
        Arrays.sort(invalidChar);
        Arrays.sort(foundChar);
        int i = offset - 1;
        while (i >= 0) {
            char c = doc.getChar(i);
            if (Arrays.binarySearch(invalidChar, c) >= 0) {
                return -1;
            }
            if (Arrays.binarySearch(foundChar, c) >= 0) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public String getElementComplationPrefix(IDocument doc, int offset) throws BadLocationException {
        int index = HTContentAssistProcessor.getComplationPrefixIndex(doc, offset, new char[]{'<'}, new char[]{'>', ' ', '\t', '\r', '\n'});
        return this.getComplationPrefix(doc, offset, index);
    }

    public String getComplationPrefix(IDocument doc, int offset, int index) throws BadLocationException {
        return index != -1 ? doc.get(index, offset - index) : null;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IDocument doc = viewer.getDocument();
        try {
            switch (this.getMode(doc, offset)) {
                case 1: {
                    return this.createElementCompletionProposals(viewer, offset, null);
                }
                case 2: {
                    String prefix = this.getElementComplationPrefix(doc, offset);
                    return this.createElementCompletionProposals(viewer, offset, prefix);
                }
                case 4: {
                    return this.createAttributeCompletionProposals(viewer, offset);
                }
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    int getMode(IDocument doc, int offset) throws BadLocationException {
        if (HTParser.isInToken(doc, offset)) {
            char c = doc.getChar(offset);
            if (doc.getChar(offset - 1) == '<') {
                return 2;
            }
            if (this.getElementComplationPrefix(doc, offset) != null) {
                return 2;
            }
            if (c == '>' || c == ' ') {
                return 4;
            }
            return 0;
        }
        return 1;
    }

    ICompletionProposal[] createElementCompletionProposals(ITextViewer viewer, int offset, String prefix) throws BadLocationException {
        String[] candities;
        String elemName;
        IDocument doc = viewer.getDocument();
        int replaceLength = 0;
        if (prefix != null) {
            elemName = HTParser.chooseElementName(doc, offset, 1);
            int tmpOffset = HTParser.getElementRange(doc, offset).getOffset();
            replaceLength = offset - tmpOffset;
            offset = tmpOffset;
        } else {
            elemName = HTParser.getElementName(doc, offset);
        }
        if (elemName != null && (candities = engine.getCandidateElements(elemName)) != null) {
            ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
            String tagPrefix = prefix != null && prefix.length() >= 2 && prefix.charAt(0) == '<' ? prefix.substring(1) : null;
            int i = 0;
            while (i < candities.length) {
                if (tagPrefix == null || candities[i].startsWith(tagPrefix)) {
                    proposals.add(this.createElementProposal(candities[i], offset, replaceLength));
                }
                ++i;
            }
            if (proposals.size() > 0) {
                return proposals.toArray(new ICompletionProposal[proposals.size()]);
            }
        }
        return null;
    }

    void p(Object o) {
        System.out.println(this.getClass() + ":" + o);
    }

    CompletionProposal createElementProposal(String elemName, int offset, int replaceLength) {
        String insertString = engine.isEmptyElement(elemName) ? "<" + elemName + " />" : "<" + elemName + "></" + elemName + ">";
        return new CompletionProposal(insertString, offset, replaceLength, elemName.length() + 2, this.colorManager.getImage("obj16/tag.gif"), elemName, null, null);
    }

    ICompletionProposal[] createAttributeCompletionProposals(ITextViewer viewer, int offset) throws BadLocationException {
        String[] candities;
        IDocument doc = viewer.getDocument();
        String elemName = HTParser.getElementName(doc, offset);
        if (elemName != null && (candities = engine.getCandidateAttribute(elemName)) != null) {
            int index = HTContentAssistProcessor.getComplationPrefixIndex(doc, offset, spaceChars, new char[]{'<', '\"'});
            String attPrefix = this.getComplationPrefix(doc, offset, index);
            if (attPrefix != null && (attPrefix = attPrefix.trim()).length() == 0) {
                attPrefix = null;
            }
            int replaceLength = 0;
            if (attPrefix != null) {
                int tmpOffset = offset - attPrefix.length();
                replaceLength = offset - tmpOffset;
                offset = tmpOffset;
            }
            ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
            int i = 0;
            while (i < candities.length) {
                if (attPrefix == null || candities[i].startsWith(attPrefix)) {
                    boolean insertBeforeSpace = Arrays.binarySearch(spaceChars, doc.getChar(offset - 1)) < 0;
                    proposals.add(this.createAttributeProposal(candities[i], offset, replaceLength, insertBeforeSpace));
                }
                ++i;
            }
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }
        return null;
    }

    CompletionProposal createAttributeProposal(String attrName, int offset, int replaceLength, boolean insertBeforeSpace) {
        String insertString = String.valueOf(attrName) + "=\"\"";
        if (insertBeforeSpace) {
            insertString = String.valueOf(' ') + insertString;
        }
        return new CompletionProposal(insertString, offset, replaceLength, attrName.length() + (insertBeforeSpace ? 3 : 2), this.colorManager.getImage("obj16/attribute.gif"), attrName, null, null);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return (char[])this.autoActivationChars.clone();
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

