/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.actions;

import com.narucy.webpub.core.HTMLUtilities;
import com.narucy.webpub.ui.WebpubUIPlugin;
import java.util.Arrays;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class UnescapeTagAction
implements IEditorActionDelegate {
    final String[] replaceStrings;
    ITextEditor editor = null;
    ITextSelection selection = null;

    public UnescapeTagAction() {
        this(new String[]{"&gt;", "&lt;", "&quot;", "&amp;"});
    }

    public UnescapeTagAction(String[] replaceStrings) {
        this.replaceStrings = replaceStrings;
        Arrays.sort(replaceStrings);
    }

    public void setActiveEditor(IAction action, IEditorPart ed) {
        this.editor = ed instanceof ITextEditor ? (ITextEditor)ed : null;
        action.setEnabled(this.isEnable());
    }

    public void selectionChanged(IAction action, ISelection sel) {
        this.selection = sel instanceof ITextSelection ? (ITextSelection)sel : null;
        action.setEnabled(this.isEnable());
    }

    boolean isEnable() {
        String text;
        if (this.editor != null && this.selection != null && (text = this.selection.getText()) != null) {
            int i = 0;
            while (i < this.replaceStrings.length) {
                if (text.indexOf(this.replaceStrings[i]) != -1) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void run(IAction action) {
        if (this.isEnable()) {
            IDocument doc = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
            try {
                this.doReplace(doc, this.selection);
            }
            catch (BadLocationException e) {
                WebpubUIPlugin.handleException((Exception)((Object)e));
            }
        }
    }

    protected void doReplace(IDocument doc, ITextSelection sel) throws BadLocationException {
        doc.replace(sel.getOffset(), sel.getLength(), HTMLUtilities.unescape((String)sel.getText()));
    }
}

