/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class JFaceUtilities {
    public static final IInputValidator FILE_EXTENSION_VALIDATOR = new IInputValidator(){
        char[] invalidChars = "\\/:;*,?<>| \t\r\n".toCharArray();

        public String isValid(String newName) {
            int i = 0;
            while (i < this.invalidChars.length) {
                char ch = this.invalidChars[i];
                if (newName.indexOf(ch) != -1) {
                    return "Invalid char code \"" + ch + "\"";
                }
                ++i;
            }
            if (newName.length() > 0 && newName.charAt(0) == '.') {
                return "Not need to specify first char \".\"";
            }
            return null;
        }
    };

    private JFaceUtilities() {
    }

    public static IPreferencePage findPreferencePage(Shell sh, Class klass) {
        PreferenceDialog[] dialogs = JFaceUtilities.getPreferenceDialogs(sh.getDisplay());
        int i = 0;
        while (i < dialogs.length) {
            PreferenceDialog dialog = dialogs[i];
            Object[] list = dialog.getPreferenceManager().getElements(1).toArray();
            int j = 0;
            while (j < list.length) {
                IPreferencePage page = ((IPreferenceNode)list[j]).getPage();
                if (page.getClass().equals(klass)) {
                    return page;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static IWizardContainer[] getWizardContainers(Display disp) {
        ArrayList<Window> list = new ArrayList<Window>();
        Window[] windows = JFaceUtilities.getAllWindows(disp);
        int i = 0;
        while (i < windows.length) {
            Window win = windows[i];
            if (win instanceof IWizardContainer) {
                list.add(win);
            }
            ++i;
        }
        return list.toArray(new IWizardContainer[list.size()]);
    }

    public static PreferenceDialog[] getPreferenceDialogs(Display disp) {
        ArrayList<Window> list = new ArrayList<Window>();
        Window[] windows = JFaceUtilities.getAllWindows(disp);
        int i = 0;
        while (i < windows.length) {
            Window win = windows[i];
            if (win instanceof PreferenceDialog) {
                list.add(win);
            }
            ++i;
        }
        return list.toArray(new PreferenceDialog[list.size()]);
    }

    public static Window[] getAllWindows(Display disp) {
        ArrayList<Object> windows = new ArrayList<Object>();
        Shell[] shells = disp.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            Object data = shell.getData();
            if (data instanceof Window) {
                windows.add(data);
            }
            ++i;
        }
        return windows.toArray(new Window[windows.size()]);
    }
}

