/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.core.toc;

import com.narucy.webpub.core.ElementWriter;
import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.toc.Toc;
import com.narucy.webpub.core.toc.Topic;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class TocStore {
    static DocumentBuilder docBuilder;

    static {
        try {
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
    }

    private TocStore() {
    }

    public static void storeToc(Toc toc, IFile file) throws CoreException {
        WebProject wp = (WebProject)file.getProject().getNature("com.narucy.webpub.core.publishNature");
        String charset = wp.getString("ht_charset");
        try {
            TocStore.storeToc(toc, new FileOutputStream(file.getLocation().toFile()), charset);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.narucy.webpub.core", 0, e.getLocalizedMessage(), (Throwable)e));
        }
    }

    public static void storeToc(Toc toc, OutputStream out, String charset) throws IOException {
        block3: {
            OutputStreamWriter writer = null;
            try {
                writer = new OutputStreamWriter(out, charset);
                writer.write(TocStore.expandElement(toc));
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
                throw throwable;
            }
            Object var4_6 = null;
            if (writer == null) break block3;
            writer.flush();
            writer.close();
        }
    }

    public static String expandElement(Toc toc) {
        Document doc = TocStore.createDocModel(toc);
        return TocStore.createElementWriter().expandTag(doc.getDocumentElement());
    }

    static ElementWriter createElementWriter() {
        ElementWriter writer = new ElementWriter();
        writer.setExpandOption("toc", 3);
        writer.setExpandOption("topic", 3);
        return writer;
    }

    static Document createDocModel(Toc toc) {
        Document doc = docBuilder.newDocument();
        Element elem = doc.createElement("toc");
        doc.appendChild(elem);
        elem.setAttribute("label", toc.getLabel());
        Topic[] topics = toc.getSubtopics();
        TocStore.createTopicsDocModel(topics, doc, elem);
        return doc;
    }

    static void createTopicsDocModel(Topic[] topics, Document doc, Element elem) {
        int i = 0;
        while (i < topics.length) {
            Topic t = topics[i];
            TocStore.createTocDocModel(t, doc, elem);
            ++i;
        }
    }

    static void createTocDocModel(Topic topic, Document doc, Element parent) {
        Element elem = doc.createElement("topic");
        parent.appendChild(elem);
        elem.setAttribute("label", topic.getLabel());
        elem.setAttribute("href", topic.getHref());
        TocStore.createTopicsDocModel(topic.getSubtopics(), doc, elem);
    }
}

