/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.core.template;

import com.narucy.webpub.core.TextReader;
import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.template.Template;
import com.narucy.webpub.core.template.TemplateParseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class TemplateParser {
    static final Pattern beginPattern = Pattern.compile("^\\s*<!--\\s*\\$begin:(.+)\\$\\s*-->\\s*$");
    static final Pattern endPattern = Pattern.compile("^\\s*<!--\\s*\\$end:(.+)\\$\\s*-->\\s*$");
    static TemplateParser instance = new TemplateParser();
    public static final String FIND_LINE_NUMBER = "find_line_number";

    public static TemplateParser getInstance() {
        return instance;
    }

    private TemplateParser() {
    }

    public Template parse(IFile f) throws TemplateParseException, IOException, CoreException {
        WebProject wp = (WebProject)f.getProject().getNature("com.narucy.webpub.core.publishNature");
        String charset = wp.getString("ht_charset");
        return this.parse(f.getContents(), charset, "Root");
    }

    public Template parse(InputStream stream, String charset, String rootTmplName) throws TemplateParseException, IOException {
        TextReader reader = new TextReader(stream, charset);
        try {
            Template template = this.parse(reader, rootTmplName);
            Object var5_6 = null;
            if (reader != null) {
                reader.close();
            }
            return template;
        }
        catch (Throwable throwable) {
            block3: {
                Object var5_7 = null;
                if (reader == null) break block3;
                reader.close();
            }
            throw throwable;
        }
    }

    public Template parse(Iterator iter, String rootTmplName) throws TemplateParseException {
        Template root = new Template(rootTmplName);
        Stack<Template> stack = new Stack<Template>();
        Template template = root;
        int i = 0;
        while (iter.hasNext()) {
            String line = (String)iter.next();
            String name = TemplateParser.matchBeginTmplateLine(line);
            if (name != null) {
                Template newTemplate = new Template(name);
                newTemplate.setProperty(FIND_LINE_NUMBER, new Integer(i));
                stack.add(template);
                template.addTemplate(newTemplate);
                template = newTemplate;
            }
            if (template != null) {
                template.addLine(line);
            } else {
                root.addLine(line);
            }
            if (TemplateParser.matchEndTemplateLine(line) != null) {
                if (template == null) {
                    throw new TemplateParseException(line, i);
                }
                if (stack.isEmpty()) {
                    throw new TemplateParseException("close template error", i);
                }
                template = (Template)stack.pop();
            }
            ++i;
        }
        return root;
    }

    public static String matchBeginTmplateLine(String line) {
        Matcher beginMatch = beginPattern.matcher(line);
        if (beginMatch.matches()) {
            return beginMatch.group(1);
        }
        return null;
    }

    public static String matchEndTemplateLine(String line) {
        Matcher endMatch = endPattern.matcher(line);
        if (endMatch.matches()) {
            return endMatch.group(1);
        }
        return null;
    }
}

