/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.core.template;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.template.Template;
import com.narucy.webpub.core.template.TemplateManageException;
import com.narucy.webpub.core.template.TemplateManagerListener;
import com.narucy.webpub.core.template.TemplateParseException;
import com.narucy.webpub.core.template.TemplateParser;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public final class TemplateManager {
    public static final String ID_MARKER_TEMPLATE_ERROR = "com.narucy.webpub.core.template.error";
    static HashMap registedProjects = new HashMap();
    static TemplateParser parser = TemplateParser.getInstance();
    IProject project;
    HashMap globalTemplates = new HashMap();
    HashMap templateDefinedLocation = new HashMap();
    ArrayList listeners = new ArrayList();

    public static IProject[] getRegistedProjects() {
        return registedProjects.keySet().toArray(new IProject[registedProjects.size()]);
    }

    public static TemplateManager getManagerInstance(IProject proj) throws CoreException {
        TemplateManager manager = (TemplateManager)registedProjects.get(proj);
        if (manager == null) {
            manager = new TemplateManager(proj);
            registedProjects.put(proj, manager);
        }
        return manager;
    }

    private TemplateManager(IProject proj) throws CoreException {
        this.project = proj;
        this.researchAll((IProgressMonitor)new NullProgressMonitor());
    }

    static void deleteMakers(IResource res) throws CoreException {
        IMarker[] markers = res.findMarkers("org.eclipse.core.resources.problemmarker", false, 0);
        int j = 0;
        while (j < markers.length) {
            IMarker m = markers[j];
            if (m.getAttribute(ID_MARKER_TEMPLATE_ERROR) != null) {
                m.delete();
            }
            ++j;
        }
    }

    static void handleException(IFile file, Exception error) throws CoreException {
        IMarker marker = file.createMarker("org.eclipse.core.resources.problemmarker");
        marker.setAttribute(ID_MARKER_TEMPLATE_ERROR, true);
        if (error instanceof TemplateParseException) {
            TemplateParseException e = (TemplateParseException)error;
            marker.setAttribute("severity", 2);
            marker.setAttribute("lineNumber", e.getLineNum());
        }
        marker.setAttribute("message", (Object)error.getMessage());
    }

    void distribute(IFile file, Template tmpl) throws IOException, CoreException {
        block4: {
            OutputStreamWriter writer = null;
            try {
                WebProject wp = (WebProject)file.getProject().getNature("com.narucy.webpub.core.publishNature");
                String charset = wp.getString("ht_charset");
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file.getLocation().toFile()), charset);
                String[] lines = tmpl.getLines();
                int i = 0;
                while (i < lines.length) {
                    writer.write(lines[i]);
                    writer.write(10);
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (writer != null) {
                    writer.close();
                }
                throw throwable;
            }
            Object var8_10 = null;
            if (writer == null) break block4;
            writer.close();
        }
    }

    void p(Object o) {
        System.out.println(this.getClass() + ":" + o);
    }

    public synchronized IFile[] syncronizeTemplate(IFile[] changedFiles, IFile[] removedFile, IProgressMonitor monitor) throws CoreException {
        IFile[] distributed;
        int i = 0;
        while (i < removedFile.length) {
            this.removeGlobalTemplate(removedFile[i]);
            ++i;
        }
        if (changedFiles.length > 0) {
            ModifyTemplateProc proc = new ModifyTemplateProc(changedFiles);
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)proc, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            distributed = proc.getDistributedFiles();
        } else {
            distributed = new IFile[]{};
        }
        this.fireTemplateModified();
        return distributed;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void researchAll(IProgressMonitor monitor) throws CoreException {
        block11: {
            block10: {
                try {
                    monitor.beginTask("Researching templates", -1);
                    WebProject webProj = (WebProject)this.project.getNature("com.narucy.webpub.core.publishNature");
                    if (webProj == null) {
                        Object var7_3 = null;
                        break block10;
                    }
                    IFile[] files = webProj.findFileMembers("htsources_folder");
                    int i = 0;
                    while (true) {
                        if (i >= files.length) {
                            this.fireTemplateModified();
                            break block11;
                        }
                        IFile f = files[i];
                        try {
                            if (webProj.isHTExtension(f.getFileExtension()) && f.exists()) {
                                f.refreshLocal(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                TemplateManager.deleteMakers((IResource)f);
                                this.addGlobalTemplate(f);
                                monitor.worked(1);
                            }
                        }
                        catch (TemplateManageException e) {
                            TemplateManager.handleException(f, e);
                        }
                        catch (TemplateParseException e) {
                            TemplateManager.handleException(f, e);
                        }
                        catch (IOException e) {
                            TemplateManager.handleException(f, e);
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_4 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return;
        }
        Object var7_5 = null;
        monitor.done();
    }

    synchronized void addGlobalTemplate(IFile file) throws TemplateManageException, TemplateParseException, IOException, CoreException {
        new HashMap();
        Template rootTmpl = parser.parse(file);
        Template[] tmpls = rootTmpl.getAllTemplates();
        int i = 0;
        while (i < tmpls.length) {
            Template tmpl = tmpls[i];
            String name = tmpl.getName();
            if (!name.equals("CONTENTS")) {
                Template addedTmpl;
                List list;
                if (!this.isContainGlobalTemplate(name)) {
                    this.globalTemplates.put(name, tmpl.clone());
                    this.templateDefinedLocation.put(name, new ArrayList());
                }
                if (!(list = (List)this.templateDefinedLocation.get(name)).contains(file)) {
                    list.add(file);
                }
                if (!(addedTmpl = this.getGlobalTemplate(name)).equals(tmpl)) {
                    throw new TemplateManageException(file, name);
                }
            }
            ++i;
        }
    }

    synchronized void removeGlobalTemplate(IFile file) {
        Template[] tmpls = this.getTemplatesFromCache(file);
        int i = 0;
        while (i < tmpls.length) {
            Template template = tmpls[i];
            String tmplName = template.getName();
            List files = (List)this.templateDefinedLocation.get(tmplName);
            files.remove(file);
            if (files.size() == 0) {
                this.globalTemplates.remove(tmplName);
                this.templateDefinedLocation.remove(tmplName);
            }
            ++i;
        }
    }

    public Template[] getTemplatesFromCache(IFile file) {
        ArrayList<Template> tmpls = new ArrayList<Template>();
        Template[] globalTmpls = this.getGlobalTemplates();
        int i = 0;
        while (i < globalTmpls.length) {
            Template tmpl = globalTmpls[i];
            IFile[] definedFiles = this.getTemplateDefinedFiles(tmpl.getName());
            int j = 0;
            while (j < definedFiles.length) {
                if (definedFiles[j].equals((Object)file)) {
                    tmpls.add(tmpl);
                }
                ++j;
            }
            ++i;
        }
        return tmpls.toArray(new Template[tmpls.size()]);
    }

    public boolean isContainGlobalTemplate(String name) {
        return this.globalTemplates.containsKey(name) && this.templateDefinedLocation.containsKey(name);
    }

    public Template getGlobalTemplate(String name) {
        return (Template)this.globalTemplates.get(name);
    }

    public String[] getGlobalTemplateNames() {
        return this.globalTemplates.keySet().toArray(new String[this.globalTemplates.size()]);
    }

    public Template[] getGlobalTemplates() {
        return this.globalTemplates.values().toArray(new Template[this.globalTemplates.size()]);
    }

    public IFile[] getTemplateDefinedFiles(String name) {
        List files = (List)this.templateDefinedLocation.get(name);
        return files != null ? files.toArray(new IFile[files.size()]) : new IFile[]{};
    }

    public void addListener(TemplateManagerListener l) {
        this.listeners.add(l);
    }

    public void removeListener(TemplateManagerListener l) {
        this.listeners.remove(l);
    }

    protected void fireTemplateModified() {
        int i = 0;
        while (i < this.listeners.size()) {
            ((TemplateManagerListener)this.listeners.get(i)).templateModified(this.project);
            ++i;
        }
    }

    public static boolean isTemplateFile(IResource file) throws CoreException {
        IProject proj = file.getProject();
        if (!(file instanceof IFile)) {
            return false;
        }
        WebProject webProj = (WebProject)proj.getNature("com.narucy.webpub.core.publishNature");
        if (webProj == null || !webProj.isHTExtension(file.getFileExtension())) {
            return false;
        }
        IContainer pubFolder = webProj.getFolder("publish_folder");
        IResource res = file;
        while (!((res = res.getParent()) instanceof IProject)) {
            if (!res.equals((Object)pubFolder)) continue;
            return false;
        }
        return true;
    }

    class ModifyTemplateProc
    implements IWorkspaceRunnable {
        IFile[] checksFiles;
        ArrayList distedFiles = new ArrayList();
        String charset;

        ModifyTemplateProc(IFile[] checksFiles) throws CoreException {
            this.checksFiles = checksFiles;
            WebProject wp = (WebProject)checksFiles[0].getProject().getNature("com.narucy.webpub.core.publishNature");
            this.charset = wp.getString("ht_charset");
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            monitor.beginTask("Research templates", 1000);
            try {
                int i = 0;
                int task = 1000 / this.checksFiles.length;
                while (i < this.checksFiles.length) {
                    IFile f = this.checksFiles[i];
                    f.refreshLocal(0, (IProgressMonitor)new SubProgressMonitor(monitor, task));
                    if (f.exists()) {
                        try {
                            TemplateManager.deleteMakers((IResource)f);
                            this.autoModify(f, (IProgressMonitor)new SubProgressMonitor(monitor, task));
                            TemplateManager.this.addGlobalTemplate(f);
                        }
                        catch (TemplateParseException e) {
                            TemplateManager.handleException(f, e);
                        }
                        catch (IOException e) {
                            TemplateManager.handleException(f, e);
                        }
                        catch (TemplateManageException e) {
                            TemplateManager.handleException(f, e);
                        }
                    }
                    monitor.worked(task);
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                monitor.done();
                throw throwable;
            }
            Object var6_11 = null;
            monitor.done();
        }

        void autoModify(IFile file, IProgressMonitor monitor) throws TemplateParseException, IOException, CoreException, TemplateManageException {
            monitor.beginTask("Modify that content changed file has template that relational resources", 1);
            try {
                file.getProject();
                if (!file.isSynchronized(0)) {
                    file.refreshLocal(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                Template[] maybeModifiedTemplates = parser.parse(file.getContents(), this.charset, file.getFullPath().toString()).getAllTemplates();
                ArrayList<IFile> relationFiles = new ArrayList<IFile>();
                ArrayList<Template> changeTemplates = new ArrayList<Template>();
                int i = 0;
                while (i < maybeModifiedTemplates.length) {
                    block15: {
                        Template maybeNewTmpl = maybeModifiedTemplates[i];
                        String name = maybeNewTmpl.getName();
                        if (!name.equals("CONTENTS")) {
                            Template globalSideTmpl = TemplateManager.this.getGlobalTemplate(name);
                            if (globalSideTmpl == null) {
                                TemplateManager.this.globalTemplates.put(name, maybeNewTmpl);
                                TemplateManager.this.templateDefinedLocation.put(name, new ArrayList());
                            } else if (!globalSideTmpl.equals(maybeNewTmpl)) {
                                int j = 0;
                                while (j < changeTemplates.size()) {
                                    Template t = (Template)changeTemplates.get(j);
                                    if (t.getName().equals(name)) {
                                        if (!t.equals(maybeNewTmpl)) {
                                            IMarker marker = file.createMarker("org.eclipse.core.resources.problemmarker");
                                            marker.setAttribute(TemplateManager.ID_MARKER_TEMPLATE_ERROR, true);
                                            marker.setAttribute("message", (Object)("Updated template found more two points in same template name:" + name));
                                            throw new TemplateManageException(file, name);
                                        }
                                        break block15;
                                    }
                                    ++j;
                                }
                                IFile[] definedFiles = TemplateManager.this.getTemplateDefinedFiles(name);
                                int j2 = 0;
                                while (j2 < definedFiles.length) {
                                    IFile f = definedFiles[j2];
                                    if (!relationFiles.contains(f)) {
                                        relationFiles.add(f);
                                    }
                                    ++j2;
                                }
                                changeTemplates.add(maybeNewTmpl);
                            }
                        }
                    }
                    ++i;
                }
                if (!changeTemplates.isEmpty() && !relationFiles.isEmpty()) {
                    Template[] changeTmpls = changeTemplates.toArray(new Template[changeTemplates.size()]);
                    int i2 = 0;
                    while (i2 < changeTmpls.length) {
                        Template t = changeTmpls[i2];
                        TemplateManager.this.globalTemplates.put(t.getName(), t);
                        ++i2;
                    }
                    IFile[] files = relationFiles.toArray(new IFile[relationFiles.size()]);
                    this.doModify(files, changeTmpls, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
            }
            catch (Throwable throwable) {
                Object var13_19 = null;
                monitor.done();
                throw throwable;
            }
            Object var13_20 = null;
            monitor.done();
        }

        IFile[] getDistributedFiles() {
            return this.distedFiles.toArray(new IFile[this.distedFiles.size()]);
        }

        void doModify(IFile[] relFiles, Template[] changeTmpls, IProgressMonitor monitor) throws TemplateParseException, IOException, CoreException {
            try {
                monitor.beginTask("Do modify for template synchronization", 1000);
                int i = 0;
                int task = 1000 / relFiles.length;
                while (i < relFiles.length) {
                    IFile f = relFiles[i];
                    TemplateManager.deleteMakers((IResource)f);
                    Template tmpl = parser.parse(f.getContents(), this.charset, "Root");
                    int j = 0;
                    while (j < changeTmpls.length) {
                        tmpl.modifyTmpl(changeTmpls[j]);
                        ++j;
                    }
                    TemplateManager.this.distribute(f, tmpl);
                    this.distedFiles.add(f);
                    f.refreshLocal(0, (IProgressMonitor)new SubProgressMonitor(monitor, task));
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                monitor.done();
                throw throwable;
            }
            Object var9_11 = null;
            monitor.done();
        }
    }
}

