/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.core.publish;

import com.narucy.webpub.core.TextReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;

class BuildResultReader
extends Thread {
    static final String COMPLETE_CODE = "!!complete!!";
    static final String BEGIN_ERROR_CODE = "!!begin-error!!";
    static final String END_ERROR_CODE = "!!end-error!!";
    boolean done = false;
    ArrayList completes = new ArrayList();
    ArrayList unknownLines = new ArrayList();
    HashMap errors = new HashMap();
    TextReader reader;

    BuildResultReader(InputStream stream, String charset) throws IOException {
        this.reader = new TextReader(stream, charset);
    }

    public void run() {
        try {
            String[] errorEntry = null;
            ArrayList<String> errorLines = new ArrayList<String>();
            while (this.reader.hasNext()) {
                String[] entry;
                String line = this.reader.nextLine();
                if (BuildResultReader.isConsoleCode(line, END_ERROR_CODE)) {
                    this.errors.put(errorEntry, errorLines.toArray(new String[errorLines.size()]));
                    errorEntry = null;
                    errorLines.clear();
                    continue;
                }
                if (errorEntry != null) {
                    errorLines.add(line);
                    continue;
                }
                if (BuildResultReader.isConsoleCode(line, BEGIN_ERROR_CODE) && (entry = line.substring(BEGIN_ERROR_CODE.length()).split("\\s+")).length == 3) {
                    errorEntry = entry;
                    continue;
                }
                if (BuildResultReader.isConsoleCode(line, COMPLETE_CODE) && (entry = line.substring(COMPLETE_CODE.length()).split("\\s+")).length == 3) {
                    this.completes.add(entry);
                    continue;
                }
                this.unknownLines.add(line);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.done = true;
            throw throwable;
        }
        Object var5_7 = null;
        this.done = true;
    }

    static boolean isConsoleCode(String line, String code) {
        return line.length() != 0 && line.charAt(0) == '!' && line.charAt(1) == '!' && line.indexOf(code) == 0;
    }

    boolean isDone() {
        return this.done;
    }

    String[] getUnparsedLines() {
        return this.unknownLines.toArray(new String[this.unknownLines.size()]);
    }
}

