/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.core;

import com.narucy.webpub.core.WebProjectAdapterFactory;
import com.narucy.webpub.core.toc.FileTocAdapterFactory;
import com.narucy.webpub.core.toc.TocAdapterFactory;
import java.io.File;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class WebpubPlugin
extends Plugin {
    public static final String ID_PLUGIN = "com.narucy.webpub.core";
    static final String[] defaultFindPath = new String[]{System.getProperty("user.rubypath"), "/usr/local/bin", "/usr/bin", "/bin", "c:/cygwin/usr/local/bin", "c:/cygwin/usr/bin", "c:/cygwin/bin", "c:/ruby/bin"};
    static final String[] supportCharsets = new String[]{"UTF-8", "Shift_JIS", "EUC-JP"};
    static final String[] interpreterFileNames = new String[]{"ruby", "ruby.exe"};
    static WebpubPlugin plugin;
    static ResourceBundle resourceBundle;
    IPath rubyCommandPath;
    WebProjectAdapterFactory webProjectAdapterFactory = new WebProjectAdapterFactory();
    Object[] adapterFactories;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public WebpubPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        Object[] objectArray = new Object[6];
        objectArray[0] = new TocAdapterFactory();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.narucy.webpub.core.toc.Topic");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[1] = clazz;
        objectArray[2] = new FileTocAdapterFactory();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[3] = clazz2;
        objectArray[4] = new WebProjectAdapterFactory();
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectArray[5] = clazz3;
        this.adapterFactories = objectArray;
        plugin = this;
        try {
            resourceBundle = ResourceBundle.getBundle("webpub");
        }
        catch (MissingResourceException missingResourceException) {
            resourceBundle = null;
        }
        this.rubyCommandPath = WebpubPlugin.findInitialInterpreter();
    }

    public static String[] getSupportCharsets() {
        return (String[])supportCharsets.clone();
    }

    public static IPath findInitialInterpreter() {
        int i = 0;
        while (i < defaultFindPath.length) {
            int j = 0;
            while (j < interpreterFileNames.length) {
                File file = new File(defaultFindPath[i], interpreterFileNames[j]);
                if (file.exists()) {
                    return new Path(file.toString());
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static WebpubPlugin getDefault() {
        return plugin;
    }

    public static ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    public IPath getRubyCommandPath() {
        return this.rubyCommandPath;
    }

    public void setRubyCommandPath(IPath rubyCommandPath) {
        this.rubyCommandPath = rubyCommandPath;
    }

    public void startup() {
        IAdapterManager manager = Platform.getAdapterManager();
        int i = 0;
        while (i < this.adapterFactories.length) {
            manager.registerAdapters((IAdapterFactory)this.adapterFactories[i], (Class)this.adapterFactories[i + 1]);
            i += 2;
        }
    }

    public void shutdown() {
        IAdapterManager manager = Platform.getAdapterManager();
        int i = 0;
        while (i < this.adapterFactories.length) {
            manager.unregisterAdapters((IAdapterFactory)this.adapterFactories[i]);
            i += 2;
        }
    }

    public Process rubyExec(String arguments, IPath workingDirectory) throws IOException {
        return WebpubPlugin.rubyExec(this.rubyCommandPath.toString(), arguments, workingDirectory);
    }

    public static Process rubyExec(String rubyCommandPath, String arguments, IPath workingDirectory) throws IOException {
        String cmd = String.valueOf(rubyCommandPath) + ' ' + arguments;
        return Runtime.getRuntime().exec(cmd, null, workingDirectory != null ? workingDirectory.toFile() : null);
    }

    public static void handleException(Exception e) {
        e.printStackTrace();
        plugin.getLog().log((IStatus)new Status(4, ID_PLUGIN, 0, e.getMessage(), (Throwable)e));
    }
}

