/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.core;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.WebResourceSelectionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class WebResourceLinkModel {
    IContainer baseContainer;
    WebProject webProject;
    ArrayList listeners = new ArrayList();
    IStatus status;
    IPath currentPath = null;
    boolean absolute = false;

    public WebResourceLinkModel(IContainer base) throws CoreException {
        this.baseContainer = base;
        this.webProject = (WebProject)base.getProject().getNature("com.narucy.webpub.core.publishNature");
        if (this.webProject == null) {
            throw new IllegalArgumentException("Invalid container need to include web project:" + base);
        }
        if (!this.isPublishFolderIncluded((IResource)base)) {
            IPath htSourcePath = this.webProject.getFolder("htsources_folder").getFullPath();
            if (!htSourcePath.isPrefixOf(base.getFullPath())) {
                throw new IllegalArgumentException("Invalid location:" + base);
            }
            this.baseContainer = this.webProject.getFolder("publish_folder");
            IPath relPath = base.getFullPath().removeFirstSegments(htSourcePath.segmentCount());
            if (!relPath.isEmpty()) {
                this.baseContainer = this.baseContainer.getFolder(relPath);
            }
        }
    }

    void p(Object o) {
        System.out.println(this.getClass() + ":" + o);
    }

    boolean isPublishFolderIncluded(IResource res) {
        IContainer c;
        IContainer publicFolder = this.webProject.getFolder("publish_folder");
        IContainer iContainer = c = res instanceof IContainer ? (IContainer)res : res.getParent();
        do {
            if (!publicFolder.equals((Object)c)) continue;
            return true;
        } while (!((c = c.getParent()) instanceof IWorkspaceRoot));
        return false;
    }

    public void setAbsolute(boolean b) {
        if (this.absolute == b) {
            return;
        }
        this.absolute = b;
        this.adjustPath();
    }

    public IPath getPath() {
        return this.currentPath;
    }

    public void setPath(String path) {
        this.setPath((IPath)new Path(path));
    }

    public void setPath(IPath path) {
        this.setPath(path, true);
    }

    public void setPath(IPath path, boolean withAbsoluteCheck) {
        if (path == this.currentPath || this.currentPath != null && this.currentPath.equals((Object)path)) {
            return;
        }
        this.currentPath = path;
        if (withAbsoluteCheck) {
            this.absolute = path.isAbsolute();
            this.adjustPath();
        }
        this.fireHTReferenceTextChanged();
        this.notifyMessage();
    }

    void notifyMessage() {
        String path;
        if (this.currentPath == null || (path = this.currentPath.toString()).length() == 0) {
            this.setStatus(4, "Need to specify link target.");
        } else if (this.currentPath.toString().indexOf(32) != -1) {
            this.setStatus(4, "Can not conain a char blink.");
        } else if (WebResourceLinkModel.isURL(path)) {
            this.setStatus(0, "");
        } else if (this.getWebResource() != null) {
            this.setStatus(0, "");
        } else {
            this.setStatus(4, "Sepcify resource is not exist");
        }
    }

    static boolean isURL(String u) {
        try {
            new URL(u);
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    void adjustPath() {
        IResource res = this.convertPathToWebResource(this.currentPath);
        if (this.absolute && !this.currentPath.isAbsolute()) {
            IPath path = res != null ? this.convertResourceToWebAbsolutePath(res) : this.currentPath.makeAbsolute();
            this.setPath(path, false);
        } else if (!this.absolute && this.currentPath.isAbsolute() && res != null) {
            this.setPath(WebResourceLinkModel.makeRelativePath(this.baseContainer.getFullPath(), res.getFullPath()), false);
        }
    }

    static IPath makeRelativePath(IPath from, IPath to) {
        if (from.equals((Object)to)) {
            return new Path(from.lastSegment());
        }
        int segments = from.matchingFirstSegments(to);
        int up = from.removeFirstSegments(segments).segmentCount();
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < up) {
            buff.append("../");
            ++i;
        }
        buff.append(to.removeFirstSegments(segments));
        return new Path(buff.toString()).makeRelative();
    }

    IPath convertResourceToWebAbsolutePath(IResource res) {
        IPath from = res.getFullPath();
        IPath to = this.webProject.getFolder("htsources_folder").getFullPath();
        int segments = to.matchingFirstSegments(from);
        if (segments != to.segmentCount() && (segments = (to = this.webProject.getFolder("publish_folder").getFullPath()).matchingFirstSegments(from)) != to.segmentCount()) {
            return null;
        }
        return new Path(String.valueOf('/') + from.removeFirstSegments(segments).toString());
    }

    IResource convertPathToWebResource(IPath path) {
        if (path.isAbsolute()) {
            return this.webProject.getFolder("publish_folder").findMember(path);
        }
        return this.baseContainer.findMember(path);
    }

    public IResource getWebResource() {
        return this.currentPath != null ? this.convertPathToWebResource(this.currentPath) : null;
    }

    public void setWebResource(IResource res) {
        if (!this.isPublishFolderIncluded(res)) {
            throw new IllegalArgumentException("Not published file specified:" + res);
        }
        if (this.absolute) {
            this.setPath(this.convertResourceToWebAbsolutePath(res), false);
        } else {
            this.setPath(WebResourceLinkModel.makeRelativePath(this.baseContainer.getFullPath(), res.getFullPath()), false);
        }
    }

    public void addListener(WebResourceSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(WebResourceSelectionListener listener) {
        this.listeners.remove(listener);
    }

    void fireHTReferenceTextChanged() {
        int i = 0;
        while (i < this.listeners.size()) {
            ((WebResourceSelectionListener)this.listeners.get(i)).resourceChanged(this.currentPath, this.getWebResource());
            ++i;
        }
    }

    void setStatus(int type, String msg) {
        Status s = new Status(type, "com.narucy.webpub.core", 0, msg, null);
        if (this.status == null || !this.status.toString().equals(s.toString())) {
            this.status = s;
            this.fireMessageChanged();
        }
    }

    void fireMessageChanged() {
        int i = 0;
        while (i < this.listeners.size()) {
            ((WebResourceSelectionListener)this.listeners.get(i)).statusChanged(this.status);
            ++i;
        }
    }
}

