/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;

public class TextReader
implements Iterator {
    InputStreamReader in;
    BufferedReader reader = null;
    String nextLine = null;

    public TextReader(URL url) throws IOException {
        this(url, null);
    }

    public TextReader(URL url, String charSet) throws IOException {
        this(url.openStream(), charSet);
    }

    public TextReader(InputStream stream) {
        this(stream, null);
    }

    public TextReader(InputStream stream, String charset) {
        try {
            this.in = charset != null ? new InputStreamReader(stream, charset) : new InputStreamReader(stream);
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public synchronized void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public boolean hasNext() {
        if (this.reader == null) {
            this.init();
        }
        return this.nextLine != null;
    }

    public Object next() {
        return this.nextLine();
    }

    void init() {
        this.reader = new BufferedReader(this.in);
        try {
            this.nextLine = this.reader.readLine();
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public String nextLine() {
        if (this.reader == null) {
            this.init();
        }
        try {
            String current = this.nextLine;
            this.nextLine = this.reader.readLine();
            if (this.nextLine == null) {
                this.close();
            }
            return current;
        }
        catch (IOException e) {
            return this.handleException(e);
        }
    }

    public String[] toLines() {
        ArrayList<String> list = new ArrayList<String>();
        while (this.hasNext()) {
            list.add(this.nextLine());
        }
        return list.toArray(new String[list.size()]);
    }

    public String joinedLines() {
        StringBuffer buff = new StringBuffer();
        String[] lines = this.toLines();
        int i = 0;
        while (i < lines.length) {
            buff.append(lines[i]);
            buff.append('\n');
            ++i;
        }
        return buff.toString();
    }

    public void remove() {
    }

    protected String handleException(IOException e) {
        e.printStackTrace();
        throw new RuntimeException(e);
    }
}

