/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RubyStacktrace
extends Throwable {
    static Pattern firstLinePattern = Pattern.compile("^([^\t].+\\.rb):(\\d+):(.+)$");
    static Pattern traceLinePattern = Pattern.compile("^\tfrom (.+\\.rb):(\\d+)(?:|:(.+))$");
    ArrayList items = new ArrayList();
    public final String script;
    public final String message;
    public final int lineNumber;

    public static RubyStacktrace[] createFromLines(String[] lines) {
        ArrayList<RubyStacktrace> traces = new ArrayList<RubyStacktrace>();
        RubyStacktrace trace = null;
        int i = 0;
        while (i < lines.length) {
            Matcher traceMatch;
            String line = lines[i];
            Matcher beginTraceMatch = firstLinePattern.matcher(line);
            if (beginTraceMatch.matches()) {
                if (trace != null) {
                    traces.add(trace);
                }
                trace = new RubyStacktrace(beginTraceMatch.group(1), Integer.parseInt(beginTraceMatch.group(2)), beginTraceMatch.group(3));
            }
            if (trace != null && (traceMatch = traceLinePattern.matcher(line)).matches()) {
                trace.addItem(traceMatch.group(1), Integer.parseInt(traceMatch.group(2)), traceMatch.group(3));
            }
            ++i;
        }
        if (trace != null) {
            traces.add(trace);
        }
        return traces.toArray(new RubyStacktrace[traces.size()]);
    }

    public RubyStacktrace(String script, int lineNumber, String message) {
        super(String.valueOf(script) + ":" + lineNumber + ":" + message);
        this.script = script;
        this.lineNumber = lineNumber;
        this.message = message;
    }

    public void addItem(String script, int lineNumber, String occasionIn) {
        this.addItem(new TraceItem(script, lineNumber, occasionIn));
    }

    public void addItem(TraceItem item) {
        this.items.add(item);
    }

    public TraceItem[] getTraceItems() {
        return this.items.toArray(new TraceItem[this.items.size()]);
    }

    public void printStackTrace(PrintWriter s) {
        s.println(this.getMessage());
        int i = 0;
        while (i < this.items.size()) {
            TraceItem item = (TraceItem)this.items.get(i);
            s.print("\tfrom " + item.script + ":" + item.lineNumber);
            if (item.occasionIn != null) {
                s.print(":" + item.occasionIn);
            }
            s.println();
            ++i;
        }
    }

    public void printStackTrace(PrintStream s) {
        this.printStackTrace(new PrintWriter(s));
    }

    public static class TraceItem {
        public final String script;
        public final String occasionIn;
        public final int lineNumber;

        public TraceItem(String script, int lineNumber, String occasionIn) {
            this.script = script;
            this.lineNumber = lineNumber;
            this.occasionIn = occasionIn;
        }

        protected Object clone() {
            return new TraceItem(this.script, this.lineNumber, this.occasionIn);
        }
    }
}

