/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.regex.Pattern;

public class FileUtilities {
    public static File copyWithDir(String fromDir, String to, Pattern[] ignoreFilePatterns) throws IOException {
        return FileUtilities.copyWithDir(new File(fromDir), new File(to), ignoreFilePatterns);
    }

    public static File copyWithDir(File fromDir, File to, Pattern[] ignoreFilePatterns) throws IOException {
        if (!fromDir.isDirectory()) {
            throw new IllegalArgumentException("specify copy target directory is not");
        }
        File toDir = new File(to, fromDir.getName());
        if (!toDir.exists()) {
            toDir.mkdirs();
        }
        FileUtilities.copyWithDirContainFiles(fromDir, toDir, ignoreFilePatterns);
        return toDir;
    }

    public static void copyWithDirContainFiles(File fromDir, File to, Pattern[] ignoreFilePatterns) throws IOException {
        File[] files = fromDir.listFiles();
        int i = 0;
        while (i < files.length) {
            File f = files[i];
            if (!FileUtilities.isMatch(ignoreFilePatterns, f)) {
                if (f.isDirectory()) {
                    File d = new File(to, f.getName());
                    d.mkdir();
                    FileUtilities.copyWithDirContainFiles(f, d, ignoreFilePatterns);
                } else if (f.isFile()) {
                    FileUtilities.copy(f, to);
                }
            }
            ++i;
        }
    }

    static boolean isMatch(Pattern[] patterns, File f) {
        if (patterns == null) {
            return true;
        }
        int i = 0;
        while (i < patterns.length) {
            Pattern pattern = patterns[i];
            if (pattern.matcher(f.getName()).matches()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void copy(String from, String to) throws IOException {
        FileUtilities.copy(new File(from), new File(to));
    }

    public static File copy(File from, File to) throws IOException {
        if (!from.isFile()) {
            throw new IllegalArgumentException("specify copy target file path is not file: " + from);
        }
        if (to.isDirectory()) {
            to = new File(to, from.getName());
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int read;
            in = new FileInputStream(from);
            out = new FileOutputStream(to);
            byte[] byteRead = new byte[1024];
            while ((read = in.read(byteRead)) != -1) {
                out.write(byteRead, 0, read);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            in.close();
            out.close();
            throw throwable;
        }
        Object var6_8 = null;
        in.close();
        out.close();
        return to;
    }

    public static void deleteDirectory(File dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Specify path is not directory:" + dir);
        }
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            File f = files[i];
            if (f.isDirectory()) {
                FileUtilities.deleteDirectory(f);
            } else if (f.isFile()) {
                f.delete();
            }
            ++i;
        }
        dir.delete();
    }
}

