/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.core;

import com.narucy.webpub.core.HTMLUtilities;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ElementWriter {
    public static final int BEGIN_CHANGELINE = 1;
    public static final int END_CHANGELINE = 2;
    boolean trim = true;
    HashMap expandOptions = new HashMap();
    int defaultExpandOption;
    String indent;

    public ElementWriter() {
        this(0, "  ");
    }

    public ElementWriter(int defaultExpandOption, String indent) {
        this.defaultExpandOption = defaultExpandOption;
        this.indent = indent;
    }

    public void setExpandOption(String elementName, int value) {
        this.expandOptions.put(elementName, new Integer(value));
    }

    public int getExpandOption(String elementName) {
        if (this.expandOptions.containsKey(elementName)) {
            return (Integer)this.expandOptions.get(elementName);
        }
        return this.defaultExpandOption;
    }

    boolean isBeginChangeLine(String elementName) {
        return (this.getExpandOption(elementName) & 1) != 0;
    }

    boolean isEndChangeLine(String elementName) {
        return (this.getExpandOption(elementName) & 2) != 0;
    }

    public String expandTag(Element element) {
        StringBuffer buff = new StringBuffer();
        this.expandTag(element, 0, buff);
        return buff.toString();
    }

    public void writeTag(Element element, OutputStream out) throws IOException {
        block3: {
            OutputStreamWriter writer = new OutputStreamWriter(out);
            try {
                writer.write("<?xml version=\"1.0\"?>\n\n");
                writer.write(new ElementWriter().expandTag(element));
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (writer != null) {
                    writer.close();
                }
                throw throwable;
            }
            Object var4_6 = null;
            if (writer == null) break block3;
            writer.close();
        }
    }

    void expandTag(Element element, int level, StringBuffer buff) {
        boolean emptyElem;
        this.expandIndent(level, buff);
        String elementName = element.getNodeName();
        buff.append(String.valueOf('<') + elementName);
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Node n = attrs.item(i);
            String v = n.getNodeValue();
            if (v != null) {
                buff.append(String.valueOf(' ') + n.getNodeName() + "=\"" + HTMLUtilities.escape(v) + "\"");
            }
            ++i;
        }
        boolean bl = emptyElem = element.getChildNodes().getLength() == 0;
        if (emptyElem) {
            buff.append(" /");
        }
        buff.append('>');
        if (!emptyElem) {
            NodeList childElements = element.getChildNodes();
            if (this.isBeginChangeLine(elementName)) {
                buff.append('\n');
            }
            int i2 = 0;
            while (i2 < childElements.getLength()) {
                Node node = childElements.item(i2);
                if (node instanceof Element) {
                    this.expandTag((Element)node, level + 1, buff);
                } else if (node instanceof Text) {
                    String text = ((Text)node).getNodeValue();
                    if (!this.trim || (text = text.trim()).length() != 0) {
                        buff.append(text);
                    }
                }
                ++i2;
            }
            this.expandIndent(level, buff);
            buff.append("</" + elementName + '>');
        }
        if (this.isEndChangeLine(elementName)) {
            buff.append('\n');
        }
    }

    void expandIndent(int level, StringBuffer buff) {
        if (this.indent != null) {
            int i = 0;
            while (i < level) {
                buff.append(this.indent);
                ++i;
            }
        }
    }

    public int getDefaultExpandOption() {
        return this.defaultExpandOption;
    }

    public void setDefaultExpandOption(int i) {
        this.defaultExpandOption = i;
    }
}

