<?php
/*
 * $Id: post.php,v 1.1 2003/07/03 13:22:52 wellwine Exp $
 * Copyright (c) 2003 by Jeremy N. Cowgar <jc@cowgar.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You may not change or alter any portion of this comment or credits
 * of supporting developers from this source code or any supporting
 * source code which is considered copyrighted (c) material of the
 * original comment or credit authors.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

include('header.php');

function weblog_too_small($hiddens, $action, $msg, $submit='')
{
  $submit = ($submit != '') ? trim($submit) : _SUBMIT;
  echo '
        <div class="confirmMsg">
          <h4>'.$msg.'</h4>
          <form method="post" action="'.$action.'">
        ';
  foreach ($hiddens as $name => $value) {
    if (is_array($value)) {
      foreach ($value as $caption => $newvalue) {
        echo '<input type="radio" name="'.$name.'" value="'.htmlspecialchars($newvalue).'" /> '.$caption;
      }
      echo '<br />';
    } else {
      echo '<input type="hidden" name="'.$name.'" value="'.htmlspecialchars($value).'" />';
    }
  }
  echo '<input type="submit" name="continue" value="'._BL_CONTINUE_EDITING.'" />
        </form>
        </div>';
}

$myts =& MyTextSanitizer::getInstance();
if (!empty($xoopsUser)) {
  $isAdmin = $xoopsUser->isAdmin($xoopsModule->mid());
  $currentuid = $xoopsUser->getVar('uid','E');
} else {
  $isAdmin = false;
  $currentuid = 0;
}

// Check to ensure this user can post.
if ((!$isAdmin && $xoopsModuleConfig['adminonly']) || $currentuid == 0) {
  redirect_header(XOOPS_URL.'/modules/weblog/index.php', 5,
                  _BL_ANON_CANNOT_POST_SORRY);
  exit();
}

// Save the post
if (!empty($_POST['post'])) {
  $title = $myts->makeTboxData4Save($_POST['title']);
  $cnts = $myts->makeTareaData4Save($_POST['contents']);
  if (strlen($cnts) < $xoopsModuleConfig['minentrysize']) {
    xoops_header();
    weblog_too_small(array('title'=>$_POST['title'],
                            'contents'=>$_POST['contents'],
                            'blog_id'=>$_POST['blog_id'],
                            'options'=>!empty($_POST['options']) ? true : false,
                            'user_id'=>$_POST['user_id'],
                            'continue'=>1),
                      'post.php',
                      sprintf(_BL_POST_TOO_SMALL, $xoopsModuleConfig['minentrysize'],
                              strlen($cnts)));
    xoops_footer();
    exit();
  }
  $blog_id = $_POST['blog_id'];
  $private = !empty($_POST['options']) ? 'Y' : 'N';
  
  $notification_handler =& xoops_gethandler('notification');
  $pageUri = XOOPS_URL.'/modules/weblog/details.php?blog_id=';
  
  if ($blog_id>0) {
    $sql=sprintf("UPDATE %s SET title='%s', contents='%s', private='%s' WHERE blog_id='%d'",
                 $xoopsDB->prefix('weblog'), $title, $cnts, $private, $blog_id);

    /*
     * For added security, if not admin, add in the user_id. Therefore we are
     * protected by unauth users as well as auth'd users trying to update other
     * people's blogs
     */
    if ($isAdmin == false) {
      $sql .= " AND user_id='".$currentuid."'";
    }
    $xoopsDB->query($sql) or die($xoopsDB->error());
    $goodPost = $xoopsDB->getAffectedRows() > 0;
    $pageUri .= $blog_id;
  } else {
    $sql=sprintf('INSERT INTO %s (user_id,created,title,contents,private) '.
                 "VALUES ('%d','%d','%s','%s','%s')",
                 $xoopsDB->prefix('weblog'), $currentuid,
                 time(), $title, $cnts, $private);
    $xoopsDB->query($sql) or die($xoopsDB->error());
    $goodPost = $xoopsDB->getAffectedRows() > 0;
    $pageUri .= $xoopsDB->getInsertId();
    
    // Send notifications only if the entry not private.
    if ($private=='N') {
      $notification_handler->triggerEvent ('blog', $xoopsUser->getVar('uid','E'), 'add',
                                           $extra_tags=array('TITLE'=>$title,
                                                             'PAGE_URI'=>$pageUri),
                                           $user_list=array(), $module_id=null,
                                           $omit_user_id=null);
    }
  }

  /*
   * If they did not affect any rows, they were probably trying to update
   * an entry that was not theirs. So check!
   */
  if ($goodPost) {
    redirect_header($pageUri,2,_BL_ENTRY_POSTED);
    exit();
  } else {
    redirect_header(XOOPS_URL.'/modules/weblog/index.php', 5,
                    _BL_ANON_CANNOT_POST_SORRY);
    exit();
  }
} else if (!empty($_POST['delete']) || (!empty($_POST['op']) && $_POST['op'] == 'delete')) {
  if (!empty($_POST['ok'])) {
    // After delete, return the user to the user's blog they were reading.
    $link=XOOPS_URL.'/modules/weblog/index.php?user_id='.$_POST['user_id'];
    $blog_id = $_POST['blog_id'];
    $sql = 'DELETE FROM '.$xoopsDB->prefix('weblog').' WHERE blog_id='.$blog_id;
    if ($isAdmin == false) {
      // Additional security. If not admin, they can only delete their own entries
      $sql .= ' AND user_id='.$currentuid;
    }
    $sql .= ' LIMIT 1'; // damage control
    $deleted=$xoopsDB->query($sql);
    if ($xoopsDB->getAffectedRows()) {
      xoops_comment_delete($xoopsModule->getVar('mid'), $blog_id);
      xoops_notification_deletebyitem($xoopsModule->getVar('mid'),
                                      'blog_entry', $blog_id);
      redirect_header($link,2,_BL_BLOG_DELETED);
    } else {
      redirect_header($link,5,_BL_BLOG_NOT_DELETED);
    }
  } else {
    require(XOOPS_ROOT_PATH.'/header.php');
    xoops_confirm(array('op' => 'delete',
                        'blog_id' => $_POST['blog_id'],
                        'ok' => 1,
                        'user_id' => $_POST['user_id']),
                  'post.php', sprintf(_BL_CONFIRM_DELETE, stripslashes($_POST['title'])));
    require(XOOPS_ROOT_PATH.'/footer.php');
  }
} else {
  // Edit/Create/Preview the post
  $blog_id=!empty($_GET['blog_id']) ? $_GET['blog_id'] : 0;
  if ($blog_id>0 && empty($_POST['preview'])) {
    $sql = 'SELECT title,contents,private,user_id FROM '.$xoopsDB->prefix('weblog')." WHERE blog_id='$blog_id'";
    $result=$xoopsDB->query($sql);
    $blog=$xoopsDB->fetchArray($result);
    $title=$blog['title'];
    $cnts=$blog['contents'];
    $private=$blog['private']=='Y';
    $user_id=$blog['user_id'];
  } else if (!empty($_POST['preview']) || !empty($_POST['continue'])) {
    $title = stripslashes($_POST['title']);
    $cnts = stripslashes($_POST['contents']);
    $blog_id = $_POST['blog_id'];
    $private = !empty($_POST['options']) ? true : false;
    $user_id = $_POST['user_id'];
  } else {
    $title = '';
    $cnts = '';
    $private=false;
    $user_id=-1;
  }
  
  $xoopsOption['template_main'] = 'weblog_post.html';
  include_once XOOPS_ROOT_PATH."/include/xoopscodes.php";
  
  // Include the page header
  include(XOOPS_ROOT_PATH.'/header.php');
  
  // Generate our form promatically
  include_once XOOPS_ROOT_PATH."/class/xoopsformloader.php";
  $blog_form = new XoopsThemeForm(_BL_POST, 'blogform', "post.php");
  $blog_form->addElement(new XoopsFormHidden('user_id',$user_id));
  $blog_form->addElement(new XoopsFormHidden('blog_id',$blog_id));
  if ($xoopsModuleConfig['minentrysize'] > 0) {
    $blog_form->addElement(new XoopsFormLabel('',sprintf(_BL_POST_MUST_BE,
                                                         $xoopsModuleConfig['minentrysize'])));
  }
  $blog_form->addElement(new XoopsFormText(_BL_TITLE,'title',
                                           $xoopsModuleConfig['editorwidth'],
                                           80, $myts->makeTboxData4Edit($title)));
  $blog_form->addElement(new XoopsFormDhtmlTextArea(_BL_CONTENTS.':','contents',
                                              $myts->makeTareaData4Edit($cnts),
                                                    $xoopsModuleConfig['editorheight'],
                                                    $xoopsModuleConfig['editorwidth']));

  // Private check box
  $private_checkbox = new XoopsFormCheckBox(_BL_OPTIONS, 'options', array('private'=>$private));
  $private_checkbox->addOption('private', _BL_PRIVATE);
  $blog_form->addElement($private_checkbox);
  
  $button_tray = new XoopsFormElementTray('' ,'');
  if ($blog_id > 0 && $isAdmin == true || $currentuid == $user_id) {
    $button_tray->addElement(new XoopsFormButton('','delete', _BL_DELETE_BUTTON, 'submit'));
  }
  $button_tray->addElement(new XoopsFormButton('', 'preview', _BL_PREVIEW_BUTTON, 'submit'));
  $button_tray->addElement(new XoopsFormButton('', 'post', _BL_POST_BUTTON, 'submit'));
  $blog_form->addElement($button_tray);
  $blog_form->assign($xoopsTpl);
  
  if (!empty($_POST['preview'])) {
    $use_avatar=0;
    $avatar_img = '';
    
    if ($xoopsModuleConfig['showavatar']) {
      $thisOwner=new XoopsUser(1);
      $avatar=$thisOwner->getVar('user_avatar','E');
      if (!empty($avatar) && $avatar != 'blank.gif') {
        $use_avatar = 1;
        $avatar_img = XOOPS_URL.'/uploads/'.$avatar;
      }
    }
    
    $xoopsTpl->assign('use_avatar',$use_avatar);
    $xoopsTpl->assign('avatar_img',$avatar_img);
    $xoopsTpl->assign('avatar_align', $xoopsModuleConfig['alignavatar']);
    
    $xoopsTpl->assign('preview', $myts->displayTarea($myts->makeTareaData4Edit($cnts),1,1,1,1,1));
    $xoopsTpl->assign('title', $title);
    $xoopsTpl->assign('is_preview',1);
    $xoopsTpl->assign('sample_date',
                      formatTimestamp(time(),
                                      $xoopsModuleConfig['dateformat'],
                                      $xoopsConfig['default_TZ']));
  } else {
    $xoopsTpl->assign('is_preview',0);
    $xoopsTpl->assign('title','');
    $xoopsTpl->assign('preview','');
    $xoopsTpl->assign('sample_date','');
  }
  
  // Include the page footer
  include(XOOPS_ROOT_PATH.'/footer.php');
}
?>