<?php
/*
 * $Id: index.php,v 1.1 2003/07/03 13:22:52 wellwine Exp $
 * Copyright (c) 2003 by Jeremy N. Cowgar <jc@cowgar.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You may not change or alter any portion of this comment or credits
 * of supporting developers from this source code or any supporting
 * source code which is considered copyrighted (c) material of the
 * original comment or credit authors.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

include('header.php');

$xoopsOption['template_main'] = 'weblog_entries.html';

// Include the page header
include(XOOPS_ROOT_PATH.'/header.php');

// Determine the user we are retrieving the blog entries for
$user_id = !empty($_GET['user_id']) ? $_GET['user_id'] : 0;
if (!empty($xoopsUser)) {
  $isAdmin = $xoopsUser->isAdmin($xoopsModule->mid());
  $currentuid = $xoopsUser->getVar('uid','E');
} else {
  $isAdmin = false;
  $currentuid = 0;
}

$myts =& MyTextSanitizer::getInstance();
$sql = 'SELECT bl.comments,bl.blog_id,bl.created, bl.user_id, u.uname,'.
    'bl.title, bl.contents, bl.private, bl.reads '.
    'FROM '.
    $xoopsDB->prefix('weblog').' as bl, '.
    $xoopsDB->prefix('users').' as u '.
    "WHERE (bl.private = 'N' OR bl.user_id='".$currentuid."') AND bl.user_id=u.uid ";

if ($user_id > 0) {
  $sql .= " AND bl.user_id='$user_id' ";
  $blogOwner=new XoopsUser($user_id);
  $page_title = sprintf(_BL_ENTRIES_FOR, $blogOwner->getVar('uname','E'));
} else {
  $page_title = _BL_MOST_RECENT;
}

$sql .= " ORDER BY bl.created DESC";
$start = !empty($_GET['start']) ? intval($_GET['start']) : 0;
$perPage=$xoopsModuleConfig['numperpage'];

$result=$xoopsDB->query($sql,$perPage,$start);
$countSql = 'SELECT count(blog_id) as count FROM '.$xoopsDB->prefix('weblog').' WHERE '.
    '(user_id = '.$currentuid." OR private = 'N')";
if ($user_id > 0) {
  $countSql .= ' AND user_id = '.$user_id;
}
$countRes=$xoopsDB->query($countSql);
$count=$xoopsDB->fetchArray($countRes);
$count=$count['count'];

$totalPages = ceil($count / $perPage);
if ( $count > $perPage ) {
  $uri='';
  if ($user_id>0) {
    $uri .= 'user_id='.$user_id;
  }
  include XOOPS_ROOT_PATH.'/class/pagenav.php';
  $nav = new XoopsPageNav($count, $perPage, $start, "start", $uri);
  $xoopsTpl->assign('pagination', $nav->renderNav(4));
} else {
  $xoopsTpl->assign('pagination', '');
}

if ($xoopsModuleConfig['update_reads_when'] == 2 && $user_id > 0 ||
    $xoopsModuleConfig['update_reads_when'] == 3)
{
  $updateReads = true;
} else {
  $updateReads = false;
}

while(list($comments,$blog_id,$created,$uid,$uname,$title,
           $contents,$private,$reads)=$xoopsDB->fetchRow($result)) {
  
  if ($updateReads==true) {
    $sql=sprintf('UPDATE %s SET reads = reads + 1 WHERE blog_id=\'%s\'',
                 $xoopsDB->prefix('weblog'), $blog_id);
    $xoopsDB->queryF($sql);
    /*
     * Increment the previous read counter to indicate the current read as well.
     * The database has already been updated to reflect this value, but $reads was
     * acquired before the update took place.
     */
    $reads++;
  }

  // Get the user, and retrieve his avatar
  $entry['use_avatar'] = 0;
  $entry['avatar_img'] = '';
  $entry['avatar_align'] = '';

  if ($xoopsModuleConfig['showavatar']) {
    $thisOwner=new XoopsUser($uid);
    $avatar=$thisOwner->getVar('user_avatar','E');
    if (!empty($avatar) && $avatar != 'blank.gif') {
      $entry['use_avatar'] = 1;
      $entry['avatar_img'] = XOOPS_URL.'/uploads/'.$avatar;
    }
  }
  
  $entry['created_date'] = formatTimestamp($created,
                                           $xoopsModuleConfig['dateformat'],
                                           $xoopsConfig['default_TZ']);
  $entry['created_time'] = formatTimestamp($created,
                                           $xoopsModuleConfig['timeformat'],
                                           $xoopsConfig['default_TZ']);
  $entry['uid'] = $uid;
  $entry['uname'] = $uname;
  $entry['title'] = $title;
  $entry['contents'] = $myts->displayTarea($contents,1,1,1,1,1,1,1,1,1);
  $entry['profileUri'] = XOOPS_URL.'/userinfo.php?uid='.$uid;
  $entry['blog_id'] = $blog_id;
  $entry['comments'] = $comments;
  $entry['is_private'] = $private == 'Y' ? 1 : 0;
  $entry['private'] = _BL_PRIVATE;
  $entry['read_users_blog'] = sprintf('<a href="index.php?user_id=%d">%s</a>',
                                      $uid, sprintf(_BL_READ_USERS_BLOG, $uname));
  $entry['provide_edit_link'] = $isAdmin || $currentuid == $uid ? 1 : 0;
  $entry['reads'] = sprintf(_BL_NUMBER_OF_READS, $reads);
  $xoopsTpl->append('entries', $entry);
}

$xoopsTpl->assign('avatar_align', $xoopsModuleConfig['alignavatar']);
$xoopsTpl->assign('page_title',$page_title);
$xoopsTpl->assign('uri', $_SERVER['QUERY_STRING']);

// Language assigns
$xoopsTpl->assign('comments_text', _BL_COMMENTS);
$xoopsTpl->assign('edit_text', _BL_EDIT);
$xoopsTpl->assign('read_text', _BL_READ);
$xoopsTpl->assign('blog_text', _BL_BLOG);
$xoopsTpl->assign('delete_text', _BL_DELETE);

// Include the page footer
include(XOOPS_ROOT_PATH.'/footer.php');
?>
