/*  ESmol - Molecular Viewer for Android

     (C) Copyright 2011, biochem_fan

     This file is part of ESmol.

     ESmol is free software: you can redistribute it and/or modify
     it under the terms of the GNU Lesser General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU Lesser General Public License for more details.

     You should have received a copy of the GNU Lesser General Public License
     along with this program.  If not, see <http://www.gnu.org/licenses/>. */

package jp.sfjp.webglmol.ESmol;

import java.util.ArrayList;

public class Atom {
	public String resn, elem, chain, atom, ss = "c";
	public float x, y, z;
	public int resi, serial;
	public Color color = ChemDatabase.defaultColor;
	public boolean hetflag;
	public ArrayList<Integer> bonds = null;//new ArrayList<Integer>();

	public final boolean isConnected(Atom atom) {
		if (bonds != null && bonds.indexOf(atom.serial) != -1) return true; // TODO: Implement

		float distSquared = (x - atom.x) * (x - atom.x) + (y - atom.y) * (y - atom.y) + (z - atom.z) * (z - atom.z);
		if (distSquared > 2.78 || Float.isNaN(distSquared)) return false;
		if (distSquared < 0.1) {
			return false;
		}
//		Log.d("isConnected", "bond between " + serial + " and " + atom.serial + ", dist^2 = " + distSquared);		
		return true;
	}
}
