/*
 * Copyright 2011 IoriAYANE
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.xii.relog.customlibrary.app;

import java.io.File;
import jp.xii.relog.customlibrary.Utility;
import jp.xii.relog.customlibrary.widget.FileListView;
import jp.xii.relog.customlibrary.widget.FileListView.onFileListListener;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnClickListener;


/**
 * ?????????????????????
 * @author Iori
 *
 */
public class FileListDialog implements onFileListListener 
	{

	private Context _parent = null;							//?
	private File _currentFile = null;						//???????
	private onFileListDialogListener _listener = null;		//??????
	private boolean _isDirectorySelect = false;			//??????????????????
	private CustomAlertDialog _dialog = null;

	/**
	 * ??????????????????
	 * @param is
	 */
	public void setDirectorySelect(boolean is){
		_isDirectorySelect = is;
	}
	public boolean isDirectorySelect(){
		return _isDirectorySelect;
	}
	
	/**
	 * ????????????????
	 * @return
	 */
	public String getSelectedFileName(){
		String ret = "";
		if(_currentFile != null){
			ret = _currentFile.getAbsolutePath();
		}
		return ret;
	}
	
	/**
	 * ??????????????
	 * @param context ?
	 */
	public FileListDialog(Context context){
		_parent = context;
	}
	
	/**
	 * ??????表?
	 * @param context ?
	 * @param path ??????????????
	 * @param title ????????????
	 */
	public void show(String path, String title){
		
		if(path == null){
			path = Utility.getSdcardPath();
		}else if(path.length() == 0){
			path = Utility.getSdcardPath();
		}
		
		FileListView list = new FileListView(_parent, new File(path), isDirectorySelect());
		list.setOnFileListListener(this);
		
		_dialog = new CustomAlertDialog(_parent);
		_dialog.setTitle(title);
		_dialog.setView(list);
		_dialog.setButton("Cancel", new OnClickListener() {

			public void onClick(DialogInterface dialog, int which) {
				//nop
			}
		});
		_dialog.show();
	}
	
	/**
	 * ????????????
	 * @param listener
	 */
	public void setOnFileListDialogListener(onFileListDialogListener listener){
		_listener = listener;
	}
	

	/**
	 * ?????????????????????
	 */

	public void onSelectFile(File file) {
		_currentFile = file;
		if(_dialog != null){
			_dialog.dismiss();
			_dialog = null;
		}
		if(_listener != null){
			_listener.onClickFileList(file);
		}
	}
	/**
	 * ?????????????????????????
	 */
	public void onSelectDirectory(File file) {
		_currentFile = file;
		if(_dialog != null){
			_dialog.dismiss();
			_dialog = null;
		}
		if(_listener != null){
			_listener.onClickFileList(file);
		}
	}
	/**
	 * ?????????????????
	 */

	public void onChangeDirectory(File file) {
		//nop
	}

	
	
	/**
	 * ????????????????????????
	 * @author Iori
	 *
	 */
	public interface onFileListDialogListener{
		public void onClickFileList(File file);
	}
	
	/**
	 * ????????????
	 * @author Iori
	 *
	 */
	public class CustomAlertDialog extends AlertDialog {

		protected CustomAlertDialog(Context context) {
			super(context);
		}

		
		protected CustomAlertDialog(Context context, int theme) {
			super(context, theme);
		}


		protected CustomAlertDialog(Context context, boolean cancelable,
				OnCancelListener cancelListener) {
			super(context, cancelable, cancelListener);
		}
	}

}

