/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.webframe.util;

public class Paginator {
    private String action = null;
    private int pageRecordCount = 100;
    private int visiblePageIndexMargin = 10;
    private int currentPageIndex = 1;
    private int recordTotal = 0;

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public int getRecordOffset() {
        return this.getRecordOffset(this.currentPageIndex);
    }

    public int getRecordOffset(int pageIndex) {
        return (pageIndex - 1) * this.pageRecordCount;
    }

    public void setRecordOffset(int recordOffset) {
        this.setRecordOffset(recordOffset, this.getPageRecordCount());
    }

    public void setRecordOffset(int recordOffset, int pageRecordCount) {
        this.setPageRecordCount(pageRecordCount);
        this.setCurrentPageIndex(recordOffset / pageRecordCount + 1);
    }

    public int getFirstRecordIndexOfPage() {
        return this.getFirstRecordIndexOfPage(this.currentPageIndex);
    }

    public int getFirstRecordIndexOfPage(int pageIndex) {
        return this.getRecordOffset(pageIndex) + 1;
    }

    public int getLastRecordIndexOfPage() {
        return this.getLastRecordIndexOfPage(this.currentPageIndex);
    }

    public int getLastRecordIndexOfPage(int pageIndex) {
        int lastIndex = this.getRecordOffset(pageIndex) + this.pageRecordCount;
        if (this.recordTotal < lastIndex) {
            lastIndex = this.recordTotal;
        }
        return lastIndex;
    }

    public int getPageTotal() {
        if (this.recordTotal == 0) {
            return 0;
        }
        int quotient = this.recordTotal / this.pageRecordCount;
        int residue = this.recordTotal % this.pageRecordCount;
        return residue > 0 ? quotient + 1 : quotient;
    }

    public int getPageRecordCount() {
        return this.pageRecordCount;
    }

    public void setPageRecordCount(int recordCount) {
        this.pageRecordCount = recordCount;
    }

    public int getPerPage() {
        return this.getPageRecordCount();
    }

    public void setPerPage(int recordCount) {
        this.setPageRecordCount(recordCount);
    }

    public int getPreviousPageIndex() {
        return 1 < this.currentPageIndex ? this.currentPageIndex - 1 : this.currentPageIndex;
    }

    public int getRecordOffsetOfPreviousPage() {
        return this.getRecordOffset(this.getPreviousPageIndex());
    }

    public int getCurrentPageIndex() {
        return this.currentPageIndex;
    }

    public void setCurrentPageIndex(int pageIndex) {
        this.currentPageIndex = pageIndex;
    }

    public int getNextPageIndex() {
        return this.currentPageIndex < this.getPageTotal() ? this.currentPageIndex + 1 : this.currentPageIndex;
    }

    public int getRecordOffsetOfNextPage() {
        return this.getRecordOffset(this.getNextPageIndex());
    }

    public boolean hasPreviousPage() {
        return 1 < this.currentPageIndex;
    }

    public boolean hasNextPage() {
        return this.currentPageIndex < this.getPageTotal();
    }

    public boolean isVisiblePageIndex(int pageIndex) {
        return this.currentPageIndex - this.visiblePageIndexMargin <= pageIndex && pageIndex < this.currentPageIndex + this.visiblePageIndexMargin;
    }

    public int getRecordTotal() {
        return this.recordTotal;
    }

    public void setRecordTotal(int recordTotal) {
        this.recordTotal = recordTotal;
    }

    public int getVisiblePageIndexMargin() {
        return this.visiblePageIndexMargin;
    }

    public void setVisiblePageIndexMargin(int visiblePageIndexMargin) {
        this.visiblePageIndexMargin = visiblePageIndexMargin;
    }
}

