/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.webframe.struts.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import org.apache.commons.collections.map.TypedMap;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.DefinitionsFactory;
import org.apache.struts.tiles.DefinitionsFactoryConfig;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.FactoryNotFoundException;
import org.apache.struts.tiles.NoSuchDefinitionException;

public class StrutsUtils {
    public static Map getModuleConfigs(Action action) {
        return StrutsUtils.getModuleConfigs(action.getServlet());
    }

    public static Map getModuleConfigs(ActionServlet servlet) {
        Map moduleConfigs = TypedMap.decorate(new HashMap(), String.class, ModuleConfig.class);
        moduleConfigs.put("", StrutsUtils.getModuleConfig("", servlet));
        Enumeration names = servlet.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith("config/")) continue;
            String prefix = name.substring(6);
            moduleConfigs.put(prefix, StrutsUtils.getModuleConfig(prefix, servlet));
        }
        return moduleConfigs;
    }

    public static ModuleConfig getModuleConfig(String prefix, Action action) {
        return StrutsUtils.getModuleConfig(prefix, action.getServlet());
    }

    public static ModuleConfig getModuleConfig(String prefix, ActionServlet servlet) {
        ServletContext context = servlet.getServletContext();
        return (ModuleConfig)context.getAttribute("org.apache.struts.action.MODULE" + prefix);
    }

    public static DefinitionsFactory getTilesDefinitionsFactory(String prefix, Action action, ServletRequest request) throws FactoryNotFoundException {
        ServletContext context = action.getServlet().getServletContext();
        DefinitionsFactory definitionsFactory = null;
        definitionsFactory = (DefinitionsFactory)context.getAttribute("org.apache.struts.tiles.DEFINITIONS_FACTORY" + prefix);
        if (definitionsFactory != null) {
            return definitionsFactory;
        }
        throw new FactoryNotFoundException("DefinitionsFactory (prefix: " + prefix + ") not found.");
    }

    public static DefinitionsFactoryConfig getTilesDefinitionsFactoryConfig(String prefix, Action action, ServletRequest request) throws FactoryNotFoundException {
        DefinitionsFactory definitionsFactory = StrutsUtils.getTilesDefinitionsFactory(prefix, action, request);
        return definitionsFactory.getConfig();
    }

    public static ComponentDefinition getTilesComponentDefinition(String prefix, String path, Action action, ServletRequest request) throws NoSuchDefinitionException, DefinitionsFactoryException {
        DefinitionsFactory definitionsFactory = StrutsUtils.getTilesDefinitionsFactory(prefix, action, request);
        ServletContext context = action.getServlet().getServletContext();
        ComponentDefinition componentDefinition = definitionsFactory.getDefinition(path, request, context);
        return componentDefinition;
    }
}

