/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.webframe.springframework.util;

import javax.servlet.ServletContext;
import jp.sourceforge.webframe.springframework.util.SpringBeanHolder;
import jp.sourceforge.webframe.springframework.util.SpringContextHolder;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.apache.struts.action.Action;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.struts.ContextLoaderPlugIn;

public class SpringUtils {
    public static WebApplicationContext getWebApplicationContext(Action action) throws IllegalStateException {
        return SpringUtils.getWebApplicationContext(action);
    }

    public static WebApplicationContext getWebApplicationContext(ServletContext servletContext) throws IllegalStateException {
        WebApplicationContext wac = (WebApplicationContext)servletContext.getAttribute(ContextLoaderPlugIn.SERVLET_CONTEXT_PREFIX);
        if (wac == null) {
            wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        }
        return wac;
    }

    public static SpringContextHolder getSpringContextHolder(Action action) throws IllegalStateException {
        return SpringUtils.getSpringContextHolder(action.getServlet().getServletContext());
    }

    public static SpringContextHolder getSpringContextHolder(ServletContext servletContext) throws IllegalStateException {
        ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)SpringUtils.getWebApplicationContext(servletContext);
        SpringContextHolder contextHolder = new SpringContextHolder(applicationContext);
        return contextHolder;
    }

    public static SpringBeanHolder[] getSpringBeanHolders(ConfigurableApplicationContext applicationContext) {
        if (applicationContext != null) {
            String[] beanNames = applicationContext.getBeanDefinitionNames();
            return SpringUtils.getSpringBeanHoldersForNames(applicationContext, beanNames);
        }
        throw new IllegalArgumentException("applicationContext is null.");
    }

    public static SpringBeanHolder[] getSpringBeanHoldersForType(ConfigurableApplicationContext applicationContext, Class type) {
        if (applicationContext != null) {
            String[] beanNames = applicationContext.getBeanNamesForType(type);
            return SpringUtils.getSpringBeanHoldersForNames(applicationContext, beanNames);
        }
        throw new IllegalArgumentException("applicationContext is null.");
    }

    public static SpringBeanHolder[] getSpringBeanHoldersForNames(ConfigurableApplicationContext applicationContext, String[] beanNames) {
        if (applicationContext != null) {
            ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
            SpringBeanHolder[] beanHolders = new SpringBeanHolder[beanNames.length];
            int i = 0;
            while (i < beanNames.length) {
                beanHolders[i] = new SpringBeanHolder(beanFactory, beanNames[i]);
                ++i;
            }
            return beanHolders;
        }
        throw new IllegalArgumentException("applicationContext is null.");
    }

    public static SpringBeanHolder getSpringBeanHolder(ConfigurableApplicationContext applicationContext, String beanName) throws NoSuchBeanDefinitionException {
        if (applicationContext != null) {
            ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
            return new SpringBeanHolder(beanFactory, beanName);
        }
        throw new IllegalArgumentException("applicationContext is null.");
    }

    public static BidiMap getSpringBeanSingletonNameObjectIdMap(SpringBeanHolder[] beanHolders) {
        DualHashBidiMap singletonNameObjectIdMap = new DualHashBidiMap();
        int i = 0;
        while (i < beanHolders.length) {
            if (beanHolders[i].isSingleton()) {
                singletonNameObjectIdMap.put((Object)beanHolders[i].getBeanName(), (Object)beanHolders[i].getActualSingletonObjectId());
            }
            ++i;
        }
        return singletonNameObjectIdMap;
    }
}

