/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.webframe.compass.gps.device.ibatis;

import com.ibatis.common.util.PaginatedList;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapSession;
import java.sql.SQLException;
import java.util.Iterator;
import org.compass.core.CompassSession;
import org.compass.gps.CompassGpsException;
import org.compass.gps.device.ibatis.SqlMapClientGpsDevice;
import org.compass.gps.device.ibatis.SqlMapGpsDeviceException;

public class ExtendedSqlMapClientGpsDevice
extends SqlMapClientGpsDevice {
    protected void doIndex(CompassSession session) throws CompassGpsException {
        int pageSize = this.getPageSize();
        String[] selectStatementsIds = this.getSelectStatementsIds();
        SqlMapClient sqlMapClient = this.getSqlMapClient();
        Object[] statementsParameterObjects = this.getStatementsParameterObjects();
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)this.buildMessage("Indexing the database with page size [" + pageSize + "] ..."));
        }
        int i = 0;
        while (i < selectStatementsIds.length) {
            SqlMapSession sqlMapSession = sqlMapClient.openSession();
            try {
                try {
                    sqlMapSession.startTransaction();
                    Object parameterObject = null;
                    if (statementsParameterObjects != null) {
                        parameterObject = statementsParameterObjects[i];
                    }
                    PaginatedList paginatedList = sqlMapSession.queryForPaginatedList(selectStatementsIds[i], parameterObject, pageSize);
                    this.log.info((Object)this.buildMessage("Indexing select statement id [" + selectStatementsIds[i] + "] ..."));
                    int pageIndex = 0;
                    int docCount = 0;
                    paginatedList.gotoPage(pageIndex);
                    while (true) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)this.buildMessage("Indexing select statement id [" + selectStatementsIds[i] + "] page [" + pageIndex + "] ..."));
                        }
                        Iterator it = paginatedList.iterator();
                        while (it.hasNext()) {
                            session.create(it.next());
                            ++docCount;
                        }
                        session.evictAll();
                        if (!paginatedList.isNextPageAvailable()) break;
                        paginatedList.gotoPage(++pageIndex);
                    }
                    this.log.info((Object)this.buildMessage(String.valueOf(docCount) + " documents indexed by select statement id [" + selectStatementsIds[i] + "]"));
                    sqlMapSession.commitTransaction();
                }
                catch (SQLException e) {
                    throw new SqlMapGpsDeviceException("Failed to fetch paginated list for statement [" + selectStatementsIds[i] + "]", (Throwable)e);
                }
            }
            finally {
                try {
                    try {
                        sqlMapSession.endTransaction();
                    }
                    catch (Exception e) {
                        this.log.warn((Object)this.buildMessage("Failed to close sqlMap session, ignoring"), (Throwable)e);
                    }
                }
                finally {
                    sqlMapSession.close();
                }
            }
            ++i;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)this.buildMessage("Finished indexing the database"));
        }
    }
}

