/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.ws.search;

import java.rmi.Remote;
import java.rmi.RemoteException;

import jp.sourceforge.webframe.compass.SearchFailedException;

/**
 * SearchWebService
 *
 * @author Yomei Komiya
 *
 * @deprecated Use jp.sourceforge.metasearch.ws.SearchWebService
 *		of <a href="http://metasearch.sourceforge.jp/">MetaSearch project</a>
 * @version $Id: SearchWebService.java 6 2007-06-27 13:49:06Z whitestar $
 */
public interface SearchWebService extends Remote {

	/**
	 * Get Version
	 * 
	 * @return Version
	 * @throws RemoteException
	 */
	public abstract String getVersion() throws RemoteException;

	/**
	 * Find Documents
	 * 
	 * @param query Query String
	 * @return Result Object
	 * @throws RemoteException
	 */
	public abstract Result find(String query)
		throws SearchFailedException, RemoteException;

	/**
	 * Seek Search Result
	 * 
	 * @param query Query String
	 * @param num Display Number per Page
	 * @param start Display Start Position
	 * @return Result Object
	 * @throws RemoteException
	 */
	public abstract Result seek(String query, int num, int start)
		throws SearchFailedException, RemoteException;

	/**
	 * Refine Search
	 * 
	 * @param query New Query String
	 * @param currentQuery Current Query String
	 * @param num Display Number per Page
	 * @param start Display Start Position
	 * @return Result Object
	 * @throws RemoteException
	 */
	public abstract Result refineSearch(
			String query,
			String currentQuery,
			int num,
			int start)
		throws SearchFailedException, RemoteException;

}
