/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.compass.entity;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.oro.text.perl.Perl5Util;

/**
 * PukiWikiBean
 *
 * @author Yomei Komiya
 * @since 0.9.1
 *
 * @deprecated Use jp.sourceforge.metasearch.compass.entity.PukiWikiBean
 *		of <a href="http://metasearch.sourceforge.jp/">MetaSearch project</a>
 * @version $Id: PukiWikiBean.java 6 2007-06-27 13:49:06Z whitestar $
 */
abstract public class PukiWikiBean extends GenericTextFileEntity {
	
	/**
	 * PukiWiki page name encoding char set
	 * (e.g. EUC-JP, UTF8)
	 */
	private String pageNameEncodingCharset = "EUC-JP";

	
	/*
	 * @see jp.sourceforge.webframe.compass.entity.Searchable#buildIdentifier()
	 */
	public void buildIdentifier() {
		// http://hostname/context/index.php?<URL encoded page name>
		try {
			this.setIdentifier(
					this.getResourceContext()
					+ URLEncoder.encode(
							this.getTitle(), this.pageNameEncodingCharset));
		}
		catch (UnsupportedEncodingException e) {
			this.setIdentifier(null);
			e.printStackTrace();
		}
	}

	
	/*
	 * @see jp.sourceforge.webframe.compass.entity.TextFileSearchable#loadFile(java.io.File, java.lang.String, int)
	 */
	public void loadFile(File file, String encoding, int maxSize) {
		super.loadFile(file, encoding, maxSize);
		
		// normalize title
		try {
			Perl5Util perl = new Perl5Util();
			boolean match = perl.match("/^(.*)(\\.txt)$/", this.getTitle());
		
			if (match){
				byte[] title = Hex.decodeHex(perl.group(1).toCharArray());
			
				this.setTitle(new String(title, this.pageNameEncodingCharset));
			}
		}
		catch (DecoderException e) {
			e.printStackTrace();
		}
		catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
	}


	public String getPageNameEncodingCharset() {
		return pageNameEncodingCharset;
	}


	public void setPageNameEncodingCharset(String pageNameEncodingCharset) {
		this.pageNameEncodingCharset = pageNameEncodingCharset;
	}


	public String toString() {
		String str = new ToStringBuilder(this)
			.append("page name encoding charset", pageNameEncodingCharset)
			.toString();
		str += " < " + super.toString();
		
		return str;
	}
	
}
