/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.webframe.velocity.tools.generic;

import jp.sourceforge.webframe.velocity.tools.generic.StringTool;
import junit.framework.TestCase;

public class StringToolTest
extends TestCase {
    private StringTool stringTool = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.stringTool = new StringTool();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCapitalize() {
        StringToolTest.assertEquals((String)"", (String)this.stringTool.capitalize(null));
        StringToolTest.assertEquals((String)"Capitalize", (String)this.stringTool.capitalize("capitalize"));
    }

    public void testCapitalizeAllWords() {
        StringToolTest.assertEquals((String)"", (String)this.stringTool.capitalizeAllWords(null));
        StringToolTest.assertEquals((String)"Capitalize All Words", (String)this.stringTool.capitalizeAllWords("capitalize all words"));
    }

    public void testDefaultIfEmpty() {
        StringToolTest.assertEquals((String)"original", (String)this.stringTool.defaultIfEmpty("original", "defaultStr"));
        StringToolTest.assertEquals((String)"defaultStr", (String)this.stringTool.defaultIfEmpty(null, "defaultStr"));
        StringToolTest.assertEquals((String)"defaultStr", (String)this.stringTool.defaultIfEmpty("", "defaultStr"));
    }

    public void testDefaultStringString() {
        StringToolTest.assertEquals((String)"original", (String)this.stringTool.defaultString("original"));
        StringToolTest.assertEquals((String)"", (String)this.stringTool.defaultString(null));
        StringToolTest.assertEquals((String)"", (String)this.stringTool.defaultString(""));
    }

    public void testDefaultStringStringString() {
        StringToolTest.assertEquals((String)"original", (String)this.stringTool.defaultString("original", "defaultStr"));
        StringToolTest.assertEquals((String)"defaultStr", (String)this.stringTool.defaultString(null, "defaultStr"));
        StringToolTest.assertEquals((String)"", (String)this.stringTool.defaultString("", "defaultStr"));
    }

    public void testNvl() {
        StringToolTest.assertEquals((String)"original", (String)this.stringTool.nvl("original", "defaultStr"));
        StringToolTest.assertEquals((String)"defaultStr", (String)this.stringTool.nvl(null, "defaultStr"));
        StringToolTest.assertEquals((String)"", (String)this.stringTool.nvl("", "defaultStr"));
    }

    public void testToLowerCase() {
        StringToolTest.assertEquals((String)"", (String)this.stringTool.toLowerCase(null));
        StringToolTest.assertEquals((String)"tolowercase", (String)this.stringTool.toLowerCase("toLowerCase"));
    }

    public void testToUpperCase() {
        StringToolTest.assertEquals((String)"", (String)this.stringTool.toUpperCase(null));
        StringToolTest.assertEquals((String)"TOUPPERCASE", (String)this.stringTool.toUpperCase("toUpperCase"));
    }

    public void testNlToBrTag() {
        StringToolTest.assertEquals((String)"", (String)this.stringTool.nlToBrTag(null));
        StringToolTest.assertEquals((String)"new line<br/> to<br/> br tag", (String)this.stringTool.nlToBrTag("new line\n to\n br tag"));
    }

    public void testReplace() {
        StringToolTest.assertEquals((String)"", (String)this.stringTool.replace(null, "target", "replacement"));
        StringToolTest.assertEquals((String)"replacement string", (String)this.stringTool.replace("target string", "target", "replacement"));
    }

    public void testTrim() {
        StringToolTest.assertEquals((String)"", (String)this.stringTool.trim(null));
        StringToolTest.assertEquals((String)"trim string", (String)this.stringTool.trim("\t  trim string   "));
    }

    public void testStripString() {
        StringToolTest.assertEquals((String)"", (String)this.stringTool.strip(null));
        StringToolTest.assertEquals((String)"abc", (String)this.stringTool.strip("   abc  "));
    }

    public void testStripStringString() {
        StringToolTest.assertEquals((String)"", (String)this.stringTool.strip(null, "xyz"));
        StringToolTest.assertEquals((String)"axbzc", (String)this.stringTool.strip("xyaxbzcz", "xyz"));
    }

    public void testTruncateStringInt() {
        StringToolTest.assertEquals((String)"", (String)this.stringTool.truncate(null, 5));
        StringToolTest.assertEquals((String)"trunc", (String)this.stringTool.truncate("truncate string", 5));
        StringToolTest.assertEquals((String)"a bit", (String)this.stringTool.truncate("a bit", 5));
    }

    public void testTruncateStringIntString() {
        StringToolTest.assertEquals((String)"", (String)this.stringTool.truncate(null, 5, "---"));
        StringToolTest.assertEquals((String)"trunc...", (String)this.stringTool.truncate("truncate string", 5, null));
        StringToolTest.assertEquals((String)"trunc---", (String)this.stringTool.truncate("truncate string", 5, "---"));
        StringToolTest.assertEquals((String)"a bit", (String)this.stringTool.truncate("a bit", 5, "---"));
    }

    public void testFirstToken() {
        StringToolTest.assertEquals((String)"", (String)this.stringTool.firstToken(null, ","));
        StringToolTest.assertEquals((String)"all", (String)this.stringTool.firstToken("all,token", ","));
    }

    public void testLastToken() {
        StringToolTest.assertEquals((String)"", (String)this.stringTool.lastToken(null, "."));
        StringToolTest.assertEquals((String)"token", (String)this.stringTool.lastToken("all.token", "."));
    }

    public void testLeft() {
        StringToolTest.assertEquals((String)"", (String)this.stringTool.left(null, 5));
        StringToolTest.assertEquals((String)"left*", (String)this.stringTool.left("left*string", 5));
    }

    public void testLeftPadStringInt() {
        StringToolTest.assertEquals((String)"          ", (String)this.stringTool.leftPad(null, 10));
        StringToolTest.assertEquals((String)"  left pad", (String)this.stringTool.leftPad("left pad", 10));
    }

    public void testLeftPadStringIntString() {
        StringToolTest.assertEquals((String)"**********", (String)this.stringTool.leftPad(null, 10, "*"));
        StringToolTest.assertEquals((String)"##left pad", (String)this.stringTool.leftPad("left pad", 10, "#"));
    }

    public void testRight() {
        StringToolTest.assertEquals((String)"", (String)this.stringTool.right(null, 5));
        StringToolTest.assertEquals((String)"tring", (String)this.stringTool.right("right*string", 5));
    }

    public void testRightPadStringInt() {
        StringToolTest.assertEquals((String)"          ", (String)this.stringTool.rightPad(null, 10));
        StringToolTest.assertEquals((String)"right pad ", (String)this.stringTool.rightPad("right pad", 10));
    }

    public void testRightPadStringIntString() {
        StringToolTest.assertEquals((String)"**********", (String)this.stringTool.rightPad(null, 10, "*"));
        StringToolTest.assertEquals((String)"right pad#", (String)this.stringTool.rightPad("right pad", 10, "#"));
    }

    public void testJoinObjectArray() {
        StringToolTest.assertEquals((String)"", (String)this.stringTool.join(null));
        Object[] array = new String[]{"a", "b", "c"};
        StringToolTest.assertEquals((String)"abc", (String)this.stringTool.join(array));
    }

    public void testJoinObjectArrayString() {
        StringToolTest.assertEquals((String)"", (String)this.stringTool.join(null));
        Object[] array = new String[]{"a", "b", "c"};
        StringToolTest.assertEquals((String)"a#b#c", (String)this.stringTool.join(array, "#"));
    }

    public void testWordwrapStringInt() {
        StringToolTest.assertEquals((String)"", (String)this.stringTool.wordwrap(null, 60));
        String str = "Licensed under the Apache License, Version 2.0 (the \"License\"); you may not use this file except in compliance with the License. You may obtain a copy of the License at \thttp://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.";
        System.out.println(this.stringTool.wordwrap(str, 60));
    }

    public void testWordwrapStringIntString() {
        StringToolTest.assertEquals((String)"", (String)this.stringTool.wordwrap(null, 60, ""));
        String str = "Licensed under the Apache License, Version 2.0 (the \"License\"); you may not use this file except in compliance with the License. You may obtain a copy of the License at \thttp://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.";
        System.out.println(this.stringTool.wordwrap(str, 60, "\n\t"));
    }
}

