/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.webframe.springframework.util;

import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class SpringBeanHolder {
    private String beanName = "";
    private String[] beanAliases = null;
    private Class beanType = null;
    private BeanDefinition beanDefinition = null;
    private Object actualSingleton = null;

    public SpringBeanHolder() {
    }

    public SpringBeanHolder(ConfigurableListableBeanFactory beanFactory, String beanName) throws NoSuchBeanDefinitionException {
        this.beanName = beanName;
        this.beanAliases = beanFactory.getAliases(beanName);
        this.beanType = beanFactory.getType(beanName);
        this.beanDefinition = beanFactory.getBeanDefinition(beanName);
        this.actualSingleton = beanFactory.containsSingleton(beanName) ? beanFactory.getBean(beanName) : null;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public String[] getBeanAliases() {
        return this.beanAliases;
    }

    public void setBeanAliases(String[] beanAliases) {
        this.beanAliases = beanAliases;
    }

    public Class getBeanType() {
        return this.beanType;
    }

    public void setBeanType(Class beanType) {
        this.beanType = beanType;
    }

    public BeanDefinition getBeanDefinition() {
        return this.beanDefinition;
    }

    public void setBeanDefinition(BeanDefinition beanDefinition) {
        this.beanDefinition = beanDefinition;
    }

    public boolean isSingleton() {
        return this.beanDefinition.isSingleton();
    }

    public Object getActualSingleton() {
        return this.actualSingleton;
    }

    public void setActualSingleton(Object actualSingleton) {
        this.actualSingleton = actualSingleton;
    }

    public String getActualSingletonObjectId() {
        if (this.actualSingleton != null) {
            return Integer.toHexString(this.actualSingleton.hashCode());
        }
        return null;
    }

    public String getActualSingletonTypeName() {
        if (this.actualSingleton != null) {
            return this.actualSingleton.getClass().getName();
        }
        return null;
    }
}

