/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.webframe.io;

import java.io.File;
import java.net.URL;
import jp.sourceforge.webframe.io.DefaultByLineFileScanner;
import jp.sourceforge.webframe.io.FileLine;
import jp.sourceforge.webframe.io.LineConsumer;
import jp.sourceforge.webframe.io.ScanAbortException;
import jp.sourceforge.webframe.test.AbstractEasyMockTestCase;
import org.easymock.EasyMock;

public class DefaultByLineFileScannerTest
extends AbstractEasyMockTestCase {
    private static final String SAMPLE_CSV_FILE = "/testdata/CsvSample.EUC-JP.csv";
    private DefaultByLineFileScanner fileScanner = null;
    private LineConsumer lineConsumerMock = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void setUp() throws Exception {
        super.setUp();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.webframe.io.LineConsumer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.lineConsumerMock = (LineConsumer)this.mocksControl.createMock((Class)clazz);
        this.fileScanner = new DefaultByLineFileScanner(this.lineConsumerMock);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testScanStringString() throws Exception {
        URL fileUrl = ((Object)((Object)this)).getClass().getResource(SAMPLE_CSV_FILE);
        String encoding = "EUC-JP";
        this.mocksControl.reset();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("jp.sourceforge.webframe.io.FileLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.lineConsumerMock.consume((FileLine)EasyMock.isA((Class)clazz));
        EasyMock.expectLastCall().times(5);
        this.mocksControl.replay();
        this.fileScanner.scan(fileUrl.getPath(), encoding);
        this.mocksControl.verify();
    }

    public void testScanFileString() throws Exception {
        URL fileUrl = ((Object)((Object)this)).getClass().getResource(SAMPLE_CSV_FILE);
        File file = new File(fileUrl.getPath());
        String encoding = "EUC-JP";
        this.mocksControl.reset();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("jp.sourceforge.webframe.io.FileLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.lineConsumerMock.consume((FileLine)EasyMock.isA((Class)clazz));
        EasyMock.expectLastCall().times(5);
        this.mocksControl.replay();
        this.fileScanner.scan(file, encoding);
        this.mocksControl.verify();
        this.mocksControl.reset();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("jp.sourceforge.webframe.io.FileLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.lineConsumerMock.consume((FileLine)EasyMock.isA((Class)clazz2));
        EasyMock.expectLastCall().times(3);
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("jp.sourceforge.webframe.io.FileLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.lineConsumerMock.consume((FileLine)EasyMock.isA((Class)clazz3));
        EasyMock.expectLastCall().andThrow((Throwable)new ScanAbortException());
        this.mocksControl.replay();
        try {
            this.fileScanner.scan(file, encoding);
            DefaultByLineFileScannerTest.fail((String)"Scanning must be stopped.");
        }
        catch (ScanAbortException scanAbortException) {
            // empty catch block
        }
        this.mocksControl.verify();
    }
}

